// JavaScript Document
var docData = [];
var categoryData = [];
var berthData = [];

palettePatern = ['black','red','blue','green','purple'];

var ssid = '';
var searchLinkName = "";

var doc_bgcolor_title,doc_font_color_title,doc_font_color_detail;


$(document).ready(function(){
	
	$('#divBerthList').empty();
	$('#divBerthList').hide();
	
	ssid = $('#ssid').val();
	
	$('#startDate').mask('9999/99/99');
	$('#startDate').datepicker({dateFormat:'yy/mm/dd'});
	$("#startDate").datepicker("option", "showOn", 'button');
	$("#startDate").datepicker("option", "buttonImageOnly", true);
	$("#startDate").datepicker("option", "buttonImage", '../webnais/pilot/scripts/datepicker.png');
	$('#endDate').mask('9999/99/99');
	$('#endDate').datepicker({dateFormat:'yy/mm/dd'});
	$("#endDate").datepicker("option", "showOn", 'button');
	$("#endDate").datepicker("option", "buttonImageOnly", true);
	$("#endDate").datepicker("option", "buttonImage", '../webnais/pilot/scripts/datepicker.png');
	$("img[class='ui-datepicker-trigger']").each(function(){ 
		$(this).attr('style', 'position:relative; top:3px; left:3px;');
	});

	$('.chbFileType').prop('checked',true);
	$('#rdoKikanKbn_5').prop('checked',true);
	$('#startDate').prop('disabled',true);
	$('#endDate').prop('disabled',true);
	$("img[class='ui-datepicker-trigger']").hide();
	
	$('input[name="rdokikanKbn"]').change(function(){
		if($(this).val() === ""){
			$('#startDate').prop('disabled',false);
			$('#endDate').prop('disabled',false);
			$("img[class='ui-datepicker-trigger']").show();
		}else {
			$('#startDate').val("");
			$('#endDate').val("");
			$('#startDate').prop('disabled',true);
			$('#endDate').prop('disabled',true);
			$("img[class='ui-datepicker-trigger']").hide();
		}
	});
	
	$('#dialogSearchOption').dialog({
		autoOpen: false,
		title: "検索オプション",
		closeOnEscape: false,
		width: 500,
		modal: true,
		open: function() {
		},
		buttons: {
	        '閉じる': function(event){
				$(this).dialog("close");
			}
    	}
	});

	
	$('#dialogDocDetail').dialog({
		autoOpen: false,
		title: "発刊文書の詳細",
		closeOnEscape: false,
		width: $('body').width() * 0.78,
		height: $('body').height() * 0.5,
		modal: true,
		open: function() {
			setTimeout(function(){
				$('.ui-dialog-buttonset button:eq(2)').focus();
			},0);
		},
		buttons: {
	        '閉じる': function(){
				$(this).dialog("close");
			}
    	}
	});

	$('#searchText').focus(function(){
		if( $(this).hasClass('defaultKeyWord') ){
			$(this).val('');
			$(this).removeClass('defaultKeyWord');
		}
	});

	$('#searchText').blur(function(){
		if( $(this).val() === '' ){
			$(this).val('キーワードを指定');
			$(this).addClass('defaultKeyWord');
		}
	});

	$('#btnSearchDoc').click(function(){
		$('#divBerth').hide();
		createDocTable('4','','','');
	});

	$('#btnSearchSummary').click(function(){
		$('#divBerth').hide();
		$('#divDoc').empty();
		$('#divDoc').hide();
		$('#divPortSummary').show();
		$('#btnSearchOption').show();
		$('#divBerthList').hide();
		$('#divSearchStr').hide();
	});

	$('.portHref').click(function(){
		var portCdA = $(this).attr('data-CdA');
		searchLinkName = $(this).text();
		$('.berthList').hide();
		$('.berthList[data-CdA="'+portCdA+'"]').show();
		$('#divBerth').hide();
		createDocTable('1',portCdA,'','');
	});
	
	$('.berthHref').click(function(){
		var portCdA = $(this).attr('data-CdA');
		var berthCdB = $(this).attr('data-CdB');
		searchLinkName = $(this).text();
		createBerthLink(portCdA,berthCdB);
		$('#divBerth').show();

		createDocTable('2',portCdA,berthCdB,'');
	});
	
	$('.oceanHref').unbind().click(function(){
//		var oceanCd = $(this).attr('data-oceanCd'); 2021/11/24修正
		var oceanCd = $(this).attr('data-cdA');
		searchLinkName = $(this).text();
		$('#divBerth').hide();
		createDocTable('3','','',oceanCd);
	});
	
	//createCategoryTable();
});

function createBerthLink(cdA, cdB){
	$('#divAjax').show();
	setTimeout(function(){
		var docXml = getBerthDoc(cdA,cdB);
		switch( $(docXml).find('ret').text() ){
			case 'I001':
				var lineTag = [];
				lineTag[0] = 'line';
				
				var subLineTag = [];
				subLineTag[0] = 'detailLine';
				createData = xmlToMultiStageArray(docXml,'data',lineTag,subLineTag);
				break;
			case 'S001':
				createData = [];
				break;
			case 'E001':
				break;
		}

		cmSetXML(docXml);

		switch( $('#suiroKbn').val() ){
			case '1':
			case '2':
				$('#tdSuiroData0').hide();
				$('#tdSuiroData1').show();
				$('#tdSuiroData2').show();
				$('#tdSuiroTitle0').hide();
				$('#tdSuiroTitle1').show();
				$('#tdSuiroTitle2').show();
				break;
			default:
				$('#tdSuiroData0').show();
				$('#tdSuiroData1').hide();
				$('#tdSuiroData2').hide();
				$('#tdSuiroTitle0').show();
				$('#tdSuiroTitle1').hide();
				$('#tdSuiroTitle2').hide();
				break;
		}

		$('#divBerthDetail').empty();
		var html = '';
		for( var i = 0; i < createData[0].line.length; i++ ){
			var lineData = createData[0].line[i];
			html = html + '<div class="titlebar">';
			html = html + lineData.kindName;
			html = html + '</div>';
			var dataLineNum = 0;
			var hideFlg = false;
			for( var j = 0; j < lineData.detailLine.length; j++ ){
				var detailData = lineData.detailLine[j];
				/*
				if( dataLineNum === 4 ){
					html = html + '<div id="divHideData' + String(i) +'" style="display:none">';
					hideFlg = true;
				}
				*/
				if( detailData.title !== '' ){
					html = html + '<div>';
					dataLineNum++;
				}
				html = html + detailData.title + '&nbsp;<a href="#" class="hrefFile" data-kind="' + detailData.docKindCd + '" data-no="' + detailData.docNo + '">' + detailData.link + '</a>';
				if( j < lineData.detailLine.length - 1 ){
					if( lineData.detailLine[j+1].title !== '' ){
						html = html + '</div>';
					}
				}else{
					html = html + '</div>';
				}
			}
			/*
			if( hideFlg ){
				html = html + '</div>';
				html = html + '<a href="#" class="arrowData" style="float:right;text-decoration: none;" data-num="' + String(i) + '"><span id="spnArrow' + String(i) +'">続きを見る</span><img src="images/arrowBottom.gif" height="16" width="16" id="imgArrow' + String(i) +'" style="margin-top:2px;border:none;" ></a><div class="clear"></div>';
			}
			*/
			html = html + '<br>';
		}

		$('#divBerthDetail').append(html);

		$('.hrefFile').unbind().click(function(){
			var docKind = $(this).attr('data-kind');
			var docNo = $(this).attr('data-no');
			/*
	        window.open("/Magic33Scripts/MGrqispi.dll?APPNAME=NAIS3WEB&PRGNAME=D220&ARGUMENTS=-ANAIS3WEB,-A" + $('#ssid').val() + ",-A" + docKind + ",-A" + docNo,
	                       "",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=1,menubar=0,left=100,top=60,width=800,height=500,');
			*/
			window.open("","ファイル",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=1,menubar=0,left=100,top=60,width=800,height=500');
			$('#windowForm').attr('target','ファイル');
			$('#Wprgname').val('D220');
			$('#w_param1').val('ANAIS3WEB');
			$('#w_param2').val($('#ssid').val());
			$('#w_param3').val(docKind);
			$('#w_param4').val(docNo);
			$('#w_param5').val('');
			$('#w_param6').val('');
			$('#w_param7').val('');
			$('#w_param8').val('');
			$('#w_param9').val('');
			$('#w_param10').val('');
			$('#windowForm').submit();
			$('#windowForm').attr('target','_self');
			return false;
		});

		$('.arrowData').unbind().click(function(){
			var dataNum = $(this).attr("data-num");
			slideData(dataNum);
			return false;
		});
		$('#divAjax').hide();
	},0);
}

function slideData(dataNum){
	if($('#divHideData'+ dataNum ).css("display") === "none"){
		$('#spnArrow' + dataNum).text('隠す');
		$('#imgArrow' + dataNum).attr('src','images/arrowRight.gif');
		$('#divHideData'+ dataNum ).slideDown();
	} else {
		$('#spnArrow' + dataNum).text('続きを見る');
		$('#imgArrow' + dataNum).attr('src','images/arrowBottom.gif');
		$('#divHideData'+ dataNum ).slideUp();
	}
}

function getBerthDoc(cdA,cdB){
	var param = {
		'appname':'NAIS3WEB',
		'prgname':'D230',
		'ssid': $('#ssid').val(),
		'cdA': cdA,
		'cdB': cdB,
		'arguments':'ssid,cdA,cdB'
	};

	var xmlData = cmGetXmlData(param);
	return xmlData;
}

function createDetailTable(dataKind,dataNo,createData){

	var lineData = createData[dataKind].line[dataNo];

	$('#tbHeadDocDetail').empty();
	$('#tbBodyDocDetail').empty();
	var html = '';
	html = html + '<tr bgcolor="'+doc_bgcolor_title+'">';
	html = html + '<td><font color="'+doc_font_color_title+'"><b>[詳細]' + lineData.title  + '</b></font></td>';
    html = html + '</tr>';
	$('#tbHeadDocDetail').append(html);

	html = '';
	for( var i = 0; i < lineData.detailLine.length; i++ ){
		var detailData = lineData.detailLine[i];
		html = html + '<tr >';
		html = html + '<td>';
		html = html + '<font color="' + lineData.color + '">' + detailData.detailTitle + '</font>';
		html = html + '</td>';
		html = html + '</tr>';
	}

	$('#tbBodyDocDetail').append(html);
}

function createDocTable(kbn,cdA,cdB,oceanCd){

	$('#divPortSummary').hide();
	$('#divBerthList').hide();
	$('#divDoc').show();
	$('#btnSearchOption').hide();
	$('#divSearchStr').show();
	
	$('#divAjax').show();
	setTimeout(function(){
		$('#spnSearchStr').text(createSearchStr());
		var docXml = getPublishDoc(kbn,cdA,cdB,oceanCd);
		doc_bgcolor_title = $(docXml).find('doc_bgcolor_title').text();
		doc_font_color_title = $(docXml).find('doc_font_color_title').text();
		doc_font_color_detail = $(docXml).find('doc_font_color_detail').text();
		switch( $(docXml).find('ret').text() ){
			case 'I001':
				var lineTag = [];
				lineTag[0] = 'line';
				
				var subLineTag = [];
				subLineTag[0] = 'detailLine';

				createData = xmlToMultiStageArray(docXml,'publishLines',lineTag,subLineTag);
				docData = createData;
				break;
			case 'S001':
				createData = [];
				docData = [];
				break;
			case 'E001':
		        //location.replace("/Magic33Scripts/MGrqispi.dll?APPNAME=<!$MG_appname>&PRGNAME=W040&ARGUMENTS=''");
				break;
		}

		$('#divDoc').empty();

		if(kbn === '1'){
			var berthArr = cmXmlToArray(docXml,'berthLine');
			var berthLinkHtml = '<table width="100%;"><tbody>';
			var linkCnt =0;
			for(var i = 0; i<berthArr.length; i++){
				linkCnt = linkCnt + 1;
				if(linkCnt % 5 === 1){
					berthLinkHtml = berthLinkHtml + '<tr>';
				}
				berthLinkHtml = berthLinkHtml + 
								'<td><span style="font-size:middle;">'+
									'<a HREF="#'+berthArr[i].berthCdA+'" class="berthHref" data-CdA="'+berthArr[i].berthCdA+'" data-CdB="'+berthArr[i].berthCdB+'">'+
										berthArr[i].berthName+
									'</a>' +
								'</span></td>';
				if(linkCnt % 5 === 0){
					berthLinkHtml = berthLinkHtml + '</tr>';
				}
			}
			if(linkCnt % 5 !== 0){
				while(linkCnt % 5 !== 0){
					berthLinkHtml = berthLinkHtml + '<td><span style="font-size:middle;"></span></td>';
					linkCnt = linkCnt +1;
				}
				berthLinkHtml = berthLinkHtml + '</tr>';
			}
			
			berthLinkHtml = berthLinkHtml + '</tbody></table>';
			$('#divBerthList').html(berthLinkHtml);
			$('#divBerthList').show();
			
			$('.berthHref').on('click',function(){
				var portCdA = $(this).attr('data-CdA');
				var berthCdB = $(this).attr('data-CdB');
				searchLinkName = $(this).text();
				createBerthLink(portCdA,berthCdB);
				$('#divBerth').show();
				createDocTable('2',portCdA,berthCdB,'');
			});
			
			$('#divDoc').css('height','calc(100% - 100px)');
			$('#divDoc').css('overflow-y','scroll');
		}else if(kbn === '2'){
			$('#divBerthList').empty();
			$('#divBerthList').hide();
			var calcH =  $('#divBerth').height() + 30;
			$('#divDoc').css('height','calc(100% - '+calcH+'px)');
			$('#divDoc').css('overflow-y','scroll');
		}else {
			$('#divDoc').css('height','calc(100% - 30px)');
			$('#divDoc').css('overflow-y','scroll');
		}
		
		var html = '';

		if( createData.length <= 0 ){
			html = html + '<TABLE id="tbHeadDoc" border="0" cellspacing="0" cellpadding="2" WIDTH="99%">';
			html = html + '<tr>';
			html = html + '<td align="center" nowrap>';
			html = html + '<font color="'+doc_font_color_detail+'">検索対象の発刊文書はありません。</font>';
			html = html + '</td>';
			html = html + '</tr>';
			html = html + '</table>';
			$('#divDoc').append(html);
		}else{
			for( var i = 0; i < createData.length; i++ ){
				publishLineData = createData[i];
				html = html + '<TABLE id="tbHeadDoc' + String(i) + '" border="0" cellspacing="0" cellpadding="2" WIDTH="100%">';
				html = html + '<tr bgcolor="'+doc_bgcolor_title+'">';
				html = html + '<td colspan="6" nowrap><font color="'+doc_font_color_title+'"><b>' + publishLineData.docKindName  + '</b></font></td>';
			    html = html + '</tr>';
				html = html + '</table>';
				html = html + '<TABLE id="tbBodyDoc' + String(i) + '" border="0" cellspacing="0" cellpadding="2" WIDTH="100%">';

				var dataLineNum = 0;
				var hideFlg = false;
				for( var j = 0; j < publishLineData.line.length; j++ ){
					var lineData = publishLineData.line[j];
					dataLineNum++;
					/*
					if( dataLineNum >= 4 ){
						html = html + '<tr class="trDocData' + String(i) + '" style="display:none">';
						hideFlg = true;
					}else{
						html = html + '<tr>';
					}
					*/
					html = html + '<tr>';
					html = html + '<td align="left" width="10%" nowrap>';
					html = html + '<font id="dateFont' + String(j) + '" color="' + lineData.color + '">' + lineData.publishDate + '</font>';
					html = html + '</td>';
					html = html + '<td align="center" width="7%" nowrap>';
					html = html + '&nbsp;';
					html = html + '</td>';
					html = html + '<td>';
					html = html + '<font id="titleFont' + String(j) + '" color="' + lineData.color + '">' + lineData.title + '</font>';
					html = html + '</td>';
					html = html + '<td align="center" width="7%" nowrap>';
					if( lineData.detailFlg === '1' ){
						html = html + '<a href="#" class="detailHref" id="detail' + String(j) + '"  data-kind="' + String(i) + '" data-no="' + String(j) + '" data-title="' + lineData.title + '">詳細</a>';
					}else{
						html = html + '&nbsp;';
					}
					html = html + '</td>';
					html = html + '<td width="12%" nowrap>';
					html = html + '<font color="' + lineData.color + '">';
					if( lineData.tempFlg === '1' ){
						html = html + '<a href="#" class="hrefFile" id="href' + String(j) + '" data-kind="' + lineData.docKindCd + '" data-no="' + lineData.docNo + '"><img src="images/attachment.png" alt="添付資料" width="69" height="20" border="0" align="middle"></a>';
					}else{
						html = html + '&nbsp;';
					}
					html = html + '</font>';
					html = html + '</td>';
					html = html + '</tr>';
				}
				html = html + '</TABLE>';
				/*
				if( hideFlg ){
					html = html + '<a href="#" class="arrowDataDoc" style="float:right;text-decoration: none;" data-num="' + String(i) + '"><span id="spnArrowDoc' + String(i) +'">続きを見る</span><img src="images/arrowBottom.gif" height="16" width="16" id="imgArrowDoc' + String(i) +'" style="margin-top:2px;border:none;" ></a><div class="clear"></div>';
				}
				*/
				html = html + '<br>';
			}
			$('#divDoc').append(html);
		}

		$('.detailHref').unbind().click(function(){
			var detailData = [];
			createDetailTable($(this).attr('data-kind'),$(this).attr('data-no'),docData);
			$('#dialogDocDetail').dialog('open');
		});

		$('.hrefFile').unbind().click(function(){
			var docKind = $(this).attr('data-kind');
			var docNo = $(this).attr('data-no');
			/*
	        window.open("/Magic33Scripts/MGrqispi.dll?APPNAME=NAIS3WEB&PRGNAME=D220&ARGUMENTS=-ANAIS3WEB,-A" + $('#ssid').val() + ",-A" + docKind + ",-A" + docNo,
	                       "",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=1,menubar=0,left=100,top=60,width=800,height=500,');
						   */
			window.open("","ファイル",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=1,menubar=0,left=100,top=60,width=800,height=500');
			$('#windowForm').attr('target','ファイル');
			$('#Wprgname').val('D220');
			$('#w_param1').val('ANAIS3WEB');
			$('#w_param2').val($('#ssid').val());
			$('#w_param3').val(docKind);
			$('#w_param4').val(docNo);
			$('#w_param5').val('');
			$('#w_param6').val('');
			$('#w_param7').val('');
			$('#w_param8').val('');
			$('#w_param9').val('');
			$('#w_param10').val('');
			$('#windowForm').submit();
			$('#windowForm').attr('target','_self');
		});

		$('.arrowDataDoc').unbind().click(function(){
			var dataNum = $(this).attr("data-num");
			slideDocData(dataNum);
		});

		$('#divAjax').hide();
	},0);
}

function slideDocData(dataNum){

	$('.trDocData' + dataNum ).map(function(){
		if( $(this).css("display") === "none" ){
			$('#spnArrowDoc' + dataNum).text('隠す');
			$('#imgArrowDoc' + dataNum).attr('src','images/arrowRight.gif');
			$(this).slideDown();
		}else{
			$('#spnArrowDoc' + dataNum).text('続きを見る');
			$('#imgArrowDoc' + dataNum).attr('src','images/arrowBottom.gif');
			$(this).slideUp();
		}
	});
}

function createBerthLine(cdA){
	$('#divAjax').show();
	setTimeout(function(){
		var docXml = getBerth(cdA);
		switch( $(docXml).find('ret').text() ){
			case 'I001':
				var lineTag = [];
				lineTag[0] = 'line';
				
				var subLineTag = [];
				subLineTag[0] = 'detailLine';

				berthData = xmlToMultiStageArray(docXml,'data',lineTag,subLineTag);
				break;
			case 'E001':
		        //location.replace("/Magic33Scripts/MGrqispi.dll?APPNAME=<!$MG_appname>&PRGNAME=W040&ARGUMENTS=''");
				break;
		}

		html = '';
		for( var i = 0; i < berthData[0].line.length; i++ ){
			var lineData = berthData[0].line[i];
			for( var j = 0; j < lineData.detailLine.length; j++ ){
				var detailData = lineData.detailLine[j];
				switch( detailData.catClass ){
					case '2':
						html = html + '<TR class="trBerth tr' + cdA + '">';
						html = html + '<TD valign="center" align="left"><a href="#" style="color:black;text-decoration:none;margin-left:40px" class="berthHref" data-CdA="' + detailData.placeCdA + '" data-CdB="' + detailData.placeCdB + '">' + detailData.categoryDetail +'</a></TD>';
						html = html + '</TR>';
						break;
				}
			}
		}
		$('#trPortHref' + cdA).after(html);

		$('.berthHref').unbind().click(function(){
			createBerthLink($(this).attr('data-CdA'),$(this).attr('data-CdB'));
			$('#divBerth').show();

			createDocTable('2',$(this).attr('data-CdA'),$(this).attr('data-CdB'),'');

		});
		$('#divAjax').hide();
	},0);
}

function createCategoryTable(){

	$('#divAjax').show();
	setTimeout(function(){

		var docXml = getCategory();
		switch( $(docXml).find('ret').text() ){
			case 'I001':
				var lineTag = [];
				lineTag[0] = 'line';
				
				var subLineTag = [];
				subLineTag[0] = 'detailLine';

				categoryData = xmlToMultiStageArray(docXml,'data',lineTag,subLineTag);
				break;
			case 'E001':
		        //location.replace("/Magic33Scripts/MGrqispi.dll?APPNAME=<!$MG_appname>&PRGNAME=W040&ARGUMENTS=''");
				break;
		}

		html = '';
		for( var i = 0; i < categoryData[0].line.length; i++ ){
			var lineData = categoryData[0].line[i];
			html = html + '<div style="height:18%">';
			html = html + '<table style="border:none;" border="0" cellspacing="0" cellpadding="0" align="center" width="98%" frame="box" rules="none">';
			html = html + '<TR height="30">';
			html = html + '<TD valign="center" align="left"><font size="4">' + lineData.categoryName +'</font></TD>';
			html = html + '</TR>';
			html = html + '</TABLE>';
			html = html + '<div style="height:85%;overflow-y: scroll;">';
			html = html + '<table style="border:none;" border="0" cellspacing="0" cellpadding="0" align="center" width="98%" frame="box" rules="none">';
			for( var j = 0; j < lineData.detailLine.length; j++ ){
				var detailData = lineData.detailLine[j];
				switch( detailData.catClass ){
					case '1':
						html = html + '<TR id="trPortHref' + detailData.placeCdA + '" name="trPortHref' + detailData.placeCdA + '">';
						html = html + '<TD valign="center" align="left"><a href="#portHref' + detailData.placeCdA + '" name="portHref' + detailData.placeCdA + '" style="color:black;text-decoration:none;margin-left:20px" class="portHref" data-CdA="' + detailData.placeCdA + '">' + detailData.categoryDetail +'</a></TD>';
						html = html + '</TR>';
						break;
					case '3':
						html = html + '<TR>';
						html = html + '<TD valign="center" align="left"><a href="#oceanHref' + detailData.oceanCd + '" name="oceanHref' + detailData.oceanCd + '" style="color:black;text-decoration:none;margin-left:20px" class="oceanHref" data-Cd="' + detailData.oceanCd + '">' + detailData.categoryDetail +'</a></TD>';
						html = html + '</TR>';
						break;
					case '4':
						html = html + '<TR>';
						html = html + '<TD valign="center" align="left"><input type="checkBox" class="docCheck" name="docCheck' + detailData.docCd +'" id="docCheck' + detailData.docCd +'" data-Cd="' + detailData.docCd + '" checked="checked"><label for="docCheck' + detailData.docCd +'">' + detailData.categoryDetail + '</label></TD>';
						html = html + '</TR>';
						break;
					case '5':
						checked = ''
						if( detailData.startDate === '0000/00/00' ){
							checked = 'checked="checked"';
						}
						html = html + '<TR>';
						html = html + '<TD valign="center" align="left"><input type="radio" class="periodRadio" name="periodRadio" id="periodRadio' + String(j) + '" value="' + detailData.startDate + '" ' + checked + '><label for="periodRadio' + String(j) + '">' + detailData.categoryDetail + '</label></TD>';
						html = html + '</TR>';
						break;
				}
				html = html + '</TR>';
			}
			html = html + '</TABLE>';
			html = html + '</div>';
			html = html + '</div>';
			html = html + '<br>';
		}
		$('#divCategory').append(html);

		$('.portHref').unbind().click(function(){

			$('#divBerth').hide();

			$('.trBerth').map(function(){
				$(this).hide();
			});

			if( $('.tr' + $(this).attr('data-CdA')).size() === 0 ){
				createBerthLine($(this).attr('data-CdA'));
			}else{
				$('.tr' + $(this).attr('data-CdA')).map(function(){
					$(this).show();
				});
			}

			createDocTable('1',$(this).attr('data-CdA'),'','');

		});

		$('.oceanHref').unbind().click(function(){
			$('#divBerth').hide();
			createDocTable('3','','',$(this).attr('data-Cd'));
		});

		$('#divAjax').hide();
	},0);
}

function updateDocAttr(kbn,color,list){
	var param = {
		'appname':'NAIS3WEB',
		'prgname':'D210',
		'ssid': $('#ssid').val(),
		'updateKbn': kbn,
		'color': color,
		'list': list,
		'arguments':'ssid,updateKbn,color,list'
	};

	var xmlData = cmGetXmlData(param);
	if( $(xmlData).find('message').text() !== '' ){
		alert($(xmlData).find('message').text());
	}
	return xmlData;
}

function getPublishDoc(kbn,cdA,cdB,oceanCd){
	var paraCdA = '';
	var paraCdB = '';
	var paraOceanCd = '';
	var paraDocKind = '';
	var paraStartDate = '';
	var paraSearchWord = '';
	var paraFileType = '';

	switch(kbn){
		case '1':
			paraCdA = cdA;
			break;
		case '2':
			paraCdA = cdA;
			paraCdB = cdB;
			break;
		case '3':
			paraOceanCd = oceanCd;
			break;
		case '4':
			paraCdA = $('#selPort').val();
			if( !$('#searchText').hasClass('defaultKeyWord') ){
				arrSearchWord = $('#searchText').val().split(' ');
				for( var i = 0; i < arrSearchWord.length; i++ ){
					paraSearchWord = paraSearchWord + '@' + arrSearchWord[i];
				}
				if( paraSearchWord !== '' ){
					paraSearchWord = paraSearchWord.substring(1);
				}
			}

			$('.docCheck').map(function(){
				paraDocKind = paraDocKind + '@' + $(this).attr('data-Cd');
			});

			paraDocKind = paraDocKind.substring(1);
			break;
	}

	if( kbn !== '4' ){
		$('.docCheck').map(function(){
			if( $(this).prop('checked') ){
				paraDocKind = paraDocKind + '@' + $(this).attr('data-Cd');
			}
		});
		if( paraDocKind !== '' ){
			paraDocKind = paraDocKind.substring(1);
		}

		paraStartDate = $('.periodRadio:checked').val();
	}
	
	$('.chbFileType').each(function(){
		if( $(this).prop('checked') ){
			paraFileType = paraFileType + '@' + $(this).attr('data-Cd');
		}
	});
	if( paraFileType !== '' ){
		paraFileType = paraFileType.substring(1);
		paraFileTypeFlag = 1;
	}
	
	if($('input[name="rdokikanKbn"]:checked').val() === ""){
		paraStartDate = $('#startDate').val();
		paraEndDate = $('#endDate').val();
	}else {
		paraStartDate = $('input[name="rdokikanKbn"]:checked').val();
		paraEndDate = '9999/12/31';
	}
	
	var validMsg = '';
	if(paraFileType === ""){
		validMsg = validMsg + '文書種類が選択されていません。' + '<br>';
	}
	if(paraStartDate === "" && paraEndDate === ""){
		validMsg = validMsg + '期間が指定されていません。' + '<br>';
	}

	var param = {
		'appname':'NAIS3WEB',
		'prgname':'D262',
		'ssid': $('#ssid').val(),
		'searchKbn': kbn,
		'paraCdA': paraCdA,
		'paraCdB': paraCdB,
		'paraOceanCd': paraOceanCd,
		'paraFileType': paraFileType,
		'paraStartDate': paraStartDate,
		'paraEndDate': paraEndDate,
		'paraSearchWord': '',
		'arguments':'ssid,searchKbn,paraCdA,paraCdB,paraOceanCd,paraFileType,paraStartDate,paraEndDate,paraSearchWord'
	};

	var xmlData = cmGetXmlData(param);
	return xmlData;
}

function getCategory(){
	var param = {
		'appname':'NAIS3WEB',
		'prgname':'D261',
		'ssid': $('#ssid').val(),
		'arguments':'ssid'
	};

	var xmlData = cmGetXmlData(param);
	return xmlData;
}

function getBerth(cdA){
	var param = {
		'appname':'NAIS3WEB',
		'prgname':'D263',
		'ssid': $('#ssid').val(),
		'cdA':cdA,
		'arguments':'ssid,cdA'
	};

	var xmlData = cmGetXmlData(param);
	return xmlData;
}

function gotoAllSearch(){
	//var printUrl = naisserver+'?APPNAME='+nasiappname+'&PRGNAME=D270&ARGUMENTS=-A'+nasiappname+',-A'+ssid;
	//location.replace(printUrl);
	//$('#prgname').val('D270');
	$('#prgname').val('D290');
	$('#menuForm').submit();
}

function DispStatus(form)
        {
        status = ("");
        }
function ColChange(para)
		{
		para.style.color = "#800080";
		}

function NPHelp(){
	var hdnWebDocAlias = $('#hdnWebDocAlias').val();
	window.open(hdnWebDocAlias+"help/nphelp_search001.htm");
}
function openSearchOption(){
	$('#dialogSearchOption').dialog('open');
}
function createSearchStr(){
	var searchStr = '検索条件：カテゴリ検索 ' + searchLinkName;
	
	var fileTypeStr = '';
	var fileTypeCheck = 0;
	$('.chbFileType').each(function(){
		if($(this).prop('checked')){
			fileTypeStr = fileTypeStr + ',' + $('label[for="'+$(this).attr('id')+'"]').text();
		}else {
			fileTypeCheck = 1;
		}
	});
	
	if(fileTypeStr !== ''){
		if(fileTypeCheck === 0){
			fileTypeStr = '全て';
		}else {
			fileTypeStr = fileTypeStr.substring(1);
		}
		searchStr = searchStr + '  文書種類：' + fileTypeStr;
	}
	
	var KikanStr = '';
	if($('input[name="rdokikanKbn"]:checked').val() === ""){
		KikanStr = $('#startDate').val() + ' ～ ' + $('#endDate').val();
	}else {
		KikanStr = $('label[for="'+$('input[name="rdokikanKbn"]:checked').attr('id')+'"]').text();
	}
	searchStr = searchStr + '  期間：' + KikanStr;
	
	return searchStr;
}