﻿// JavaScript Document
var initOpenFlg = "<!$MG_initOpenFlg>";
var initTimeVal = "<!$MG_initTimeVal>";
var graphData = [];
var docData = [];
var tyoryuData = [];
var tyokoData = [];
var johoData = [];
var johoTitleData = [];
var categoryData = [];
var koroArray = [];
var tyokoUnderFlgData = [];
var callCount = 0;

var initDW;
var initLOA;
var initDFF;
var initDFA;
var initFromA;
var initFromB;
var initFromName;
var initFromSetsugangen;
var initToA;
var initToB;
var initToName;
var initToSetsugangen;
var initToDouji;
var initYMD;
var initD;

var targetInpCdA,targetInpCdB,targetLblNm,targetFlgSetsugangen,targetFlgDouji;

var searchChangeFLG = false;

palettePatern = ['black','red','blue','green','purple'];
$(document).ready(function(){
	
	$('#dialogMinato').dialog({
		autoOpen: false,
		title: "港選択",
		closeOnEscape: false,
		width: $('body').width() * 0.7,
		modal: true,
		open: function() {
		},
		buttons: {
	        '閉じる': function(){
				$(this).dialog("close");
			}
    	}
	});
	
	var usAgent = window.navigator.userAgent.toLowerCase();
	var appVer = window.navigator.appVersion.toLowerCase(); 
	
	if(usAgent.indexOf('msie') !== -1 && appVer.indexOf('msie 9.') !== -1){
		$('#btnWebPrint').hide();
	}
	
	searchChangeFLG = false;
	
	initDW = $('#inpSearchDW').val();
	initLOA = $('#inpSearchLOA').val();
	initDFF = $('#inpSearchDFF').val();
	initDFA = $('#inpSearchDFA').val();
	initFromA = $('#inpSearchFromA').val();
	initFromB = $('#inpSearchFromB').val();
	initFromName = $('#lblFromName').text();
	initFromSetsugangen = $('#slctSearchFromSetsugangen').val();	
	initToA = $('#inpSearchToA').val();
	initToB = $('#inpSearchToB').val();
	initToName = $('#lblToName').text();
	initToSetsugangen = $('#slctSearchToSetsugangen').val();
	initToDouji = $('#chkSearchToDouji').prop('checked');
	initYM = $('#inpSearchYM').val();
	initD = $('#inpSearchD').val();
	
	$('#slctListTimeVal').val($('#hdnListTimeVal').val());
	
	$('#slctSearchFromSetsugangen').val($('#hdnSearchFromSetsugangen').val());
	$('#slctSearchToSetsugangen').val($('#hdnSearchToSetsugangen').val());
	
	if($('#hdnSearchFromSetsugangenFlg').val() === 'True'){
		$('#divSearchFromSetsugangen').show();
	}else {
		$('#divSearchFromSetsugangen').hide();
	}
	
	if($('#hdnSearchToSetsugangenFlg').val() === 'True'){
		$('#divSearchToSetsugangen').show();
	}else {
		$('#divSearchToSetsugangen').hide();
	}	
	
	if($('#hdnSearchToDoujiFlg').val() === 'True'){
		$('#divSearchToDouji').show();
	}else {
		$('#divSearchToDouji').hide();
	}
	
	$('input[type=text].number');
	
	$('input[type="text"].number').blur(function(){
		$(this).val(setComma($(this).val()));
	});
	
	//$('#inpSearchYMD').datepicker();
	
	$('.search').change(function(){
		searchChangeFLG = true;
	});
	
});

$(window).on(
	'load',
	function(){
		setKoroCheck();

		$('a.GoToTarget').click(function(){
			var targetID = $(this).attr('href');
			if(targetID !== '#'){
				var target = $(targetID);
				if(target.get(0)){
					var parentTop = $('#divDoc').offset().top;
					var targetPos = target.offset().top - parentTop;
					//$('body,html').animate({scrollTop:targetPos});
					$('#divDispContents').animate({scrollTop:targetPos});
				}
			}else {
				$('#divDispContents').animate({scrollTop:0});
			}
			return false;
		});
	}
);

function replaceToggleGraph(str){
	switch(str){
		case 'グラフ非表示' :
			str = 'グラフ表示';
			break;
		
		case 'グラフ表示' :
			str = 'グラフ非表示';
			break;
	}
	return str;
}

function replaceToggleList(str){
	switch(str){
		case '表非表示' :
			str = '表表示';
			break;
		
		case '表表示' :
			str = '表非表示';
			break;
		
	}
	return str;
}

function setTimeiData(zoomNM){
	var zoomDOM = $(zoomNM);
	if(zoomDOM.val() === '1'){
		var targetA,targetB,targetNM,targetSetsu,targetDouji;	
		targetA = '#' + zoomDOM.attr('data-targetA');
		targetB = '#' + zoomDOM.attr('data-targetB');
		targetNM = '#' + zoomDOM.attr('data-targetLbl');
		targetSetsu = '#' + zoomDOM.attr('data-targetSetsuFlg');
		targetDouji = '#' + zoomDOM.attr('data-targetDoujiFlg');
		var getXML = getTimeiData($(targetA).val(),$(targetB).val());
		if($(getXML).find('ret').text() === 'I001'){
			$(targetA).val($(getXML).find('timeiCdA').text());
			$(targetB).val($(getXML).find('timeiCdB').text());
			$(targetNM).text($(getXML).find('timeiNM').text());
			$(targetSetsu).val($(getXML).find('setsugangenFlg').text());
			$(targetDouji).val($(getXML).find('doujiFlg').text());
		}else {
			$(targetNM).text("");
			$(targetSetsu).val("False");
			$(targetDouji).val("False");
		}
		show_hide_FromSetsugange();
		show_hide_ToSetsugange();
		show_hide_ToDouji();
		zoomDOM.val('0');
	}
}

function show_hide_FromSetsugange(){
	if($('#hdnSearchFromSetsugangenFlg').val() === 'True'){
		$('#divSearchFromSetsugangen').show();
	}else {
		$('#divSearchFromSetsugangen').hide();
		$('#slctSearchFromSetsugangen').val("");
	}
}

function show_hide_ToSetsugange(){
	if($('#hdnSearchToSetsugangenFlg').val() === 'True'){
		$('#divSearchToSetsugangen').show();
	}else {
		$('#divSearchToSetsugangen').hide();
		$('#slctSearchToSetsugangen').val("");
	}
}

function show_hide_ToDouji(){
	if($('#hdnSearchToDoujiFlg').val() === 'True'){
		$('#divSearchToDouji').show();
	}else {
		$('#divSearchToDouji').hide();
		$('#chkSearchToDouji').prop('checked',false);
	}
}



function setupGraph(){
	$("#hdnSearchKoroSeq").val('');
	$("#hdnSearchKoroName").val('');
	$("#hdnSearchKoroDisp").val('');
	
	createTargetArea();
	
	$('select.TABLE').val($('#slctListTimeVal').val());
	
	$('select.TABLE').change(function(){
		var koroSEQ = $(this).attr('data-koroSeq');
		var dataType = $(this).attr('data-type');
		changeTableSelect(koroSEQ,dataType);
	});
	
	$('select.KORO').change(function(){
		var setVal = $(this).val();
		$(this).parents().nextAll().children('select.KORO').val(setVal);
	});

	var koroCnt = countKoro();
	if(koroCnt > 0){
		searchGraphData();
	}else {
		alert('対象となる航路がありません');
	}
}

function createTargetArea(){
	koroArray = new Array();
	
	$('#divDoc').empty();
	
	$('div.KORO').each(function(){
		var koroSeq = $(this).children('input[class="koroSeq"]').val();
		var koroKbn = $(this).children('input[class="koroKbn"]').val();
		var koroName = $(this).children('input[class="koroName"]').val();
		var targetDateKbn = $(this).children('select').val();
		var setData = {'koroSeq':koroSeq,'koroKbn':koroKbn,'koroName':koroName,'targetDateKbn':targetDateKbn};
						
		var johoHTML = '<div id="div_joho_'+koroSeq+'"></div>';		
		if(koroKbn === '1' || $(this).children('input[type="checkbox"]').prop('checked')){
			var tyoryuHTML = '<div class="divKoroSet" data-koroSeq="'+koroSeq+'" data-graphType="1" style="margin:5px auto">'+
								'<span id="aTyoryuGraphToggle_'+koroSeq+'" class="GraphTitle" style="display:none;">▲CURRENT/潮流</span>' +
								'<input style="float:right;display:none;" id="btnTyoryuGraphToggle_'+koroSeq+'" type="button" value="グラフ非表示" class="ToggleGraph" data-target="#graphset_tyoryu_'+koroSeq+'">'+
								'<div style="clear:both;"></div>'+
								'<div class="graphSet" id="graphset_tyoryu_'+koroSeq+'">'+
									'<table>'+
										'<tr>'+
											'<td>'+
												'<div id="graphset_tyoryu_'+koroSeq+'">'+
													'<div style="width: 50px; height: 300px; margin: 10px 0px;">'+
														'<span id="spnTyoryuTOP_'+koroSeq+'" class="spnTyoryuTOP" style="display:block;width: 50px;height: 30px; margin: 0px;"></span>'+
														'<span id="spnTyoryuBTM_'+koroSeq+'" class="spnTyoryuBTM" style="display:block;width: 50px;height: 30px; margin: 200px 0px 0px 0px;"></span>'+
													'</div>'+
												'</div>'+
											'</td>'+
											'<td>'+
												'<div id="graph_'+koroSeq+'_tyoryu" class="divGraphTyoRyu" style="width: 870px; height: 300px; margin: 10px auto;"></div>'+
											'<td>'+
										'<tr>'+
									'</table>'+
								'</div>'+
								'<input style="float:right;display:none;" type="button" id="btnTyoryuListToggle_'+koroSeq+'" value="表非表示" class="ToggleList" data-target="#tableset_tyoryu_'+koroSeq+'">'+
								'<div style="clear:both;"></div>'+
								'<div class="listSet" id="tableset_tyoryu_'+koroSeq+'">'+
									//'<div id="div_tbl_'+koroSeq+'_tyoryu" class="divListTyoRyu" style="min-width: 310px; height: 200px; margin: 10px auto">'+
									'<div id="div_tbl_'+koroSeq+'_tyoryu" class="divListTyoRyu" style="min-width: 310px; margin: 10px auto">'+
										'<select class="TABLE" id="slct_time_tyoryu_'+koroSeq+'" data-type="tyoryu" data-koroSeq="'+koroSeq+'" style="display:none;">'+
											'<option value="1">１時間毎の値</option>'+
											'<option value="2">３０分毎の値</option>'+
											'<option value="3">１０分毎の値</option>'+
										'</select>'+
										'<div></div>'+
									'</div>'+
								'</div>'+
							'</div>';
			var tyokoHTML = '<div class="divKoroSet" data-koroSeq="'+koroSeq+'" data-graphType="2" style="margin:5px auto">'+
								'<span id="aTyokoGraphToggle_'+koroSeq+'" class="GraphTitle" style="display:none;">▲TIDE/潮高</span>' +
								'<input style="float:right;display:none;"id="btnTyokoGraphToggle_'+koroSeq+'" type="button" value="グラフ非表示" class="ToggleGraph" data-target="#graphset_tyoko_'+koroSeq+'">'+
								'<div style="clear:both;"></div>'+
								'<div class="graphSet" id="graphset_tyoko_'+koroSeq+'">'+
									'<table>'+
										'<tr><td>'+
											'<div style="width: 30px; height: 300px;  margin: 10px 0px;"></div>'+
										'</td><td>'+
											'<div id="graph_'+koroSeq+'_tyoko" class="divGraphTyoko" style="width: 870px; height: 300px; margin: 10px auto;"></div>'+
										'<td><tr>'+
									'</table>'+
								'</div>'+
								'<input style="float:right;display:none;"id="btnTyokoListToggle_'+koroSeq+'" type="button" value="表非表示" class="ToggleList" data-target="#tableset_tyoko_'+koroSeq+'">'+
								'<div style="clear:both;"></div>'+
								'<div class="listSet" id="tableset_tyoko_'+koroSeq+'">'+
									//'<div id="div_tbl_'+koroSeq+'_tyoko" class="divListTyoko" style="min-width: 310px; height: 200px; margin: 10px auto">'+
									'<div id="div_tbl_'+koroSeq+'_tyoko" class="divListTyoko" style="min-width: 310px; margin: 10px auto">'+
										'<select class="TABLE" id="slct_time_tyoko_'+koroSeq+'" data-type="tyoko" data-koroSeq="'+koroSeq+'" style="display:none;">'+
											'<option value="1">１時間毎の値</option>'+
											'<option value="2">３０分毎の値</option>'+
											'<option value="3">１０分毎の値</option>'+
										'</select>'+
										'<div></div>'+
									'</div>'+
								'</div>'+
							'</div>';
			
			var createHTML =	'<div class="JOHO">'+ johoHTML + tyokoHTML + tyoryuHTML +
									'<a href="#PageTop" class="GoToTOP" style="display:none;" id="aGoTotTop_'+koroSeq+'">▲</a>' +
								'</div>';
			$('#divDoc').append(createHTML);
			
			koroArray.push(setData);
		}
	});
	
	$('a.GoToTOP').on(
		'click',
		function(){
			$('#divDispContents').animate({scrollTop:0});
			return false;
		}
	);
		
	$('input.ToggleGraph').click(function(){
		var targetGraph= $($(this).attr("data-target"));
		var targetText = $(this).val();
		targetGraph.slideToggle();
		$(this).val(replaceToggleGraph(targetText));
		return false;
	});
	
	$('input.ToggleList').click(function(){
		var targetList= $($(this).attr("data-target"));
		var targetText = $(this).val();
		targetList.slideToggle();
		$(this).val(replaceToggleList(targetText));
		return false;
	});
	
	$('input.josenCd').change(function(){
		 $('#hdnJosenZoomFlg').val('1');
	});
	
	$('input.gesenCd').change(function(){
		 $('#hdnGesenZoomFlg').val('1');
	});
	
	$('input.josenCd').blur(function(){
		setTimeiData('#hdnJosenZoomFlg');
	});
	
	$('input.gesenCd').blur(function(){
		setTimeiData('#hdnGesenZoomFlg');
	});
	
	
	if(!$('#chbGraphDisp').prop('checked')){		
		$('div.graphSet').hide();
		$('input[type="button"].ToggleGraph').each(function(){
			$(this).val('グラフ表示');
		});
	}
}

function numericRet(str){
	var s = new Array();
    $.each( str.split(''), function(i, v){
        if( v.match(/[0-9]/gi) ){ s.push(v); }
    } );
    if(s.length > 0){
		str = s.join('');
	}else {
		str = '';
	}
	
	return str;
}

function setComma(str){
	var s = str.split('.');
	var retStr = String(s[0]).replace( /(\d)(?=(\d\d\d)+(?!\d))/g, '$1,' );
	if(s[1]){
		retStr = retStr + '.' + String(s[1]);
	}
	
	return retStr;
}

function searchGraphData(){
	docData = new Array();
	callCount = 0;
	callGraphData(callCount);
}


function callGraphData(arryIndex){
	getGraphData(koroArray[arryIndex].koroKbn,koroArray[arryIndex].koroName,koroArray[arryIndex].targetDateKbn,koroArray[arryIndex].koroSeq);
}

function createTyoryuDataArr(koroSeq){
	var timeType = $('#slct_time_tyoryu_'+koroSeq).val();
	
	var graphValArry = new Array();
	var graphTimeArry = new Array();
	var valArry = new Array();
	var timeArry = new Array();
	var colorArry = new Array();
	
	switch(timeType){
		case '1' :
			for(var i=0; i<docData[koroSeq].length; i++){
				if(docData[koroSeq][i].graphType == '1'){
					var labelFlg = false;
					if(docData[koroSeq][i].flgLabel == 'True') labelFlg = true;
					
					var graphSet = {y:Number(docData[koroSeq][i].setVal),dataLabels: {enabled: labelFlg},marker: {enabled: labelFlg},lablData:docData[koroSeq][i].setVal}
					graphValArry.push(graphSet);
					graphTimeArry.push(docData[koroSeq][i].timeVal);
					
					if(docData[koroSeq][i].flg1H == 'True'){
						valArry.push(graphSet);
						timeArry.push(docData[koroSeq][i].timeVal);
						colorArry.push(docData[koroSeq][i].tdColor);
					}
				}
				
			}
			break
		
		case '2' :
			for(var i=0; i<docData[koroSeq].length; i++){
				if(docData[koroSeq][i].graphType == '1'){
					var labelFlg = false;
					if(docData[koroSeq][i].flgLabel == 'True') labelFlg = true;
					
					var graphSet = {y:Number(docData[koroSeq][i].setVal),dataLabels: {enabled: labelFlg},marker: {enabled: labelFlg},lablData:docData[koroSeq][i].setVal}
					graphValArry.push(graphSet);
					graphTimeArry.push(docData[koroSeq][i].timeVal);
					
					if(docData[koroSeq][i].flg30M == 'True'){
						valArry.push(graphSet);
						timeArry.push(docData[koroSeq][i].timeVal);
						colorArry.push(docData[koroSeq][i].tdColor);
					}
				}
			}
			break
		
		case '3' :
			for(var i=0; i<docData[koroSeq].length; i++){
				if(docData[koroSeq][i].graphType == '1'){
					var labelFlg = false;
					if(docData[koroSeq][i].flgLabel == 'True') labelFlg = true;
					
					var graphSet = {y:Number(docData[koroSeq][i].setVal),dataLabels: {enabled: labelFlg},marker: {enabled: labelFlg},lablData:docData[koroSeq][i].setVal}
					graphValArry.push(graphSet);					
					graphTimeArry.push(docData[koroSeq][i].timeVal);
					
					if(docData[koroSeq][i].flg10M == 'True'){
						valArry.push(graphSet);
						timeArry.push(docData[koroSeq][i].timeVal);
						colorArry.push(docData[koroSeq][i].tdColor);
					}
				}
			}
			break
	}
	
	return [graphValArry,graphTimeArry,valArry,timeArry,colorArry];
}

function createTyokoDataArr(koroSeq){
	var timeType = $('#slct_time_tyoko_'+koroSeq).val()
	
	var graphValArry = new Array();
	var graphTimeArry = new Array();
	var valArry = new Array();
	var timeArry = new Array();
	var colorArry = new Array();
	switch(timeType){
		case '1' :
			for(var i=0; i<docData[koroSeq].length; i++){
				if(docData[koroSeq][i].graphType === '2'){
					var labelFlg = false;
					if(docData[koroSeq][i].flgLabel === 'True') labelFlg = true;
					var graphSet = {y:Number(docData[koroSeq][i].setVal),dataLabels: {enabled: labelFlg},marker: {enabled: labelFlg},lablData:docData[koroSeq][i].setVal}
					
					graphValArry.push(graphSet);
					graphTimeArry.push(docData[koroSeq][i].timeVal);
					
					if(docData[koroSeq][i].flg1H === 'True'){					
						valArry.push(graphSet);
						timeArry.push(docData[koroSeq][i].timeVal);
						colorArry.push(docData[koroSeq][i].tdColor);
					}
				}
			}
			break
		
		case '2' :
			for(var i=0; i<docData[koroSeq].length; i++){
				if(docData[koroSeq][i].graphType === '2'){
					var labelFlg = false;
					if(docData[koroSeq][i].flgLabel === 'True') labelFlg = true;
					var graphSet = {y:Number(docData[koroSeq][i].setVal),dataLabels: {enabled: labelFlg},marker: {enabled: labelFlg},lablData:docData[koroSeq][i].setVal}
					
					graphValArry.push(graphSet);
					graphTimeArry.push(docData[koroSeq][i].timeVal);
					
					if(docData[koroSeq][i].flg30M === 'True'){					
						valArry.push(graphSet);
						timeArry.push(docData[koroSeq][i].timeVal);
						colorArry.push(docData[koroSeq][i].tdColor);
					}
				}
			}
			break
		
		case '3' :
			for(var i=0; i<docData[koroSeq].length; i++){
				if(docData[koroSeq][i].graphType === '2'){
					var labelFlg = false;
					if(docData[koroSeq][i].flgLabel === 'True') labelFlg = true;
					var graphSet = {y:Number(docData[koroSeq][i].setVal),dataLabels: {enabled: labelFlg},marker: {enabled: labelFlg},lablData:docData[koroSeq][i].setVal}
					
					graphValArry.push(graphSet);
					graphTimeArry.push(docData[koroSeq][i].timeVal);
					
					if(docData[koroSeq][i].flg10M === 'True'){					
						valArry.push(graphSet);
						timeArry.push(docData[koroSeq][i].timeVal);
						colorArry.push(docData[koroSeq][i].tdColor);
					}
				}
			}
			break
	}
	
	return [graphValArry,graphTimeArry,valArry,timeArry,colorArry];
}

function createJohoArea(targetTblDiv,johoData,johoTitle,koroSeq,dispDateStr,ssTimeStr){
	$(targetTblDiv).empty();
	
	var spnHTML = '<div style="float:left;"><span class="JOHO" data-koroSeq="'+koroSeq+'">'+johoTitle+'</span></div>'
					+'<div style="float:right;">'
						+'<span class="DispDate" data-koroSeq="'+koroSeq+'" style="display:block; float:left;">'+dispDateStr+'</span>'
						+'<span class="SunsetSunrise" data-koroSeq="'+koroSeq+'" style="display:block; float:left; margin-left:15px;">'+ssTimeStr+'</span>'
					+'</div>'
					+'<div style="clear:both;"></div>';
					
	var tblHTML = '<table class="JOHO">';
	for(var i=0; i<johoData.length; i++){
		tblHTML = tblHTML +
				'<tr>'+
                    '<td style="vertical-align:top;">'+johoData[i].johoBiko+'</td>'+
                    '<td style="vertical-align:top;">'+johoData[i].johoFT1+'</td>'+
                    '<td style="vertical-align:top;">'+johoData[i].johoFT2+'</td>'+
                    '<td style="vertical-align:top;">'+johoData[i].johoFT3+'</td>'+
                    '<td style="vertical-align:top;">'+johoData[i].johoFT4+'</td>'+
                '</tr>'
	}
	tblHTML = tblHTML + '</table>';
	var createHTML = spnHTML + tblHTML;
	$(targetTblDiv).append(createHTML);
}

function createTyoryuTable(targetTblDiv,tyoryuData){
	var tblHTML = '<table style="float:left;" class="GRAPH">';
	tblHTML = tblHTML + '<thead><tr><td>SLACK</td><td>MAX</td><td>CURRENT</td></tr></thead>';
	for(var i=0; i<tyoryuData.length; i++){
		tblHTML = tblHTML +
				'<tr>' +
					'<td>' + tyoryuData[i].tenryuHMS + '</td>' +
					'<td>' + tyoryuData[i].maxHMS + '</td>' +
					'<td>' + tyoryuData[i].maxVal + '</td>' +
				'</tr>';
	}
	tblHTML = tblHTML + '</table>';
	$(targetTblDiv).children('div').append(tblHTML);
}

function createTyokoTable(targetTblDiv,tyokoData){
	var tblHTML = '<table style="float:left;" class="GRAPH">';
	tblHTML = tblHTML + '<thead><tr><td>TIME</td><td>TIDE</td></tr></thead>';
	for(var i=0; i<tyokoData.length; i++){
		tblHTML = tblHTML +
				'<tr>' +
					'<td>' + tyokoData[i].shioHMS + '</td>' +
					'<td>' + tyokoData[i].shioVal + '</td>' +
				'</tr>';
	}
	tblHTML = tblHTML + '</table>';
	$(targetTblDiv).children('div').append(tblHTML);
}


function createTimeTable(targetTblDiv,valData,timeData,colorData){
	var tblType = $(targetTblDiv).children('select').val();
	var tblTr = 0;
	var divH = 0;
	switch(tblType){
		case '1' : 
			tblTr = 6;
			divH = 6 * 27 + 10;
			break;
		
		case '2' : 
			tblTr = 12;
			divH = 12 * 27 + 10;
			break;
			
		case '3' : 
			tblTr = 36;
			divH = 36 * 27 + 10;
			break;
		
		default : 
			tblTr = 6;
			divH = 6 * 27 + 10;
			break;
	}
	
	var tblHTML = '';
	var roopCnt = 0;
	for(var i=0; i<valData.length; i++){
		if((roopCnt+1) % tblTr === 1){
			tblHTML = tblHTML + '<table style="float:left;" class="GRAPH">';
		}
		tblHTML = tblHTML +
					'<tr>' +
						'<td>' + timeData[i] + '</td>' +
						'<td style="color:'+colorData[i]+'">' + valData[i].lablData + '</td>' +
					'</tr>';
		if((roopCnt+1) % tblTr === 0){
			tblHTML = tblHTML + '</table>';
		}
		roopCnt = roopCnt + 1;
		/*
		if(!valData[i].dataLabels.enabled){
			if((roopCnt+1) % tblTr === 1){
				tblHTML = tblHTML + '<table style="float:left;" class="GRAPH">';
			}
			tblHTML = tblHTML +
						'<tr>' +
							'<td>' + timeData[i] + '</td>' +
							'<td style="color:'+colorData[i]+'">' + valData[i].lablData + '</td>' +
						'</tr>';
			if((roopCnt+1) % tblTr === 0){
				tblHTML = tblHTML + '</table>';
			}
			roopCnt = roopCnt + 1;
		}
		*/
	}
	
	if(tblHTML.substr(-8) !== '</table>') tblHTML = tblHTML + '</table>';
	
	tblHTML = tblHTML + '<div style="clear:both;"></div>';	
	//$(targetTblDiv).css('height',divH);
	$(targetTblDiv).children('div').append(tblHTML);
}

function createGraph(koroSeq,targetDiv,graphData,graphX,graphType,koroType,printKbn){
	var lblFontSize = '14px';
	if(printKbn) lblFontSize = '10px';
	
	var tickItv = 1;
	var tickMax = 4;
	var tickMin = -4;
	
	var maxVal = Math.ceil(getMaxVal(graphData,'y'));
	if(maxVal < 4){
		tickItv = 1;
		tickMax = 4;
		tickMin = -4;
	}else if(maxVal < 8){
		tickItv = 2;
		tickMax = 8;
		tickMin = -8;
	}else {
		tickItv = 3;
		tickMax = 12;
		tickMin = -12;
	}
		
	if(graphType === 'Tyoko') {
		tickItv = 100;
		if(tyokoUnderFlgData[koroSeq]){
			tickMax = 300;
			tickMin = -100;
		}else {
			tickMax = 400;
			tickMin = 0;
		}
	}else {
		if(koroType > -1){
			tickItv = 3;
			tickMax = 12;
			tickMin = -12;
		}
	}
	
    $(targetDiv).highcharts({
		credits: {
            enabled: false
        },
		
		exporting: {
			enabled: false
		},
		
		legend: {
            enabled: false
        },
		
        title: {
            text: '',
            x: -20 //center
        },
		
        xAxis: {
			title: {
                text: ""
            },
            categories: graphX,
			tickInterval: 12,
			gridLineWidth: 1,
			labels: {
				style: {
				  fontSize: '10px'
				}
			}
        },
		
        yAxis: {
			title: {
                text: ""
            },
            plotLines: [{
                value: 0,
                width: 2,
                color: '#000000',
                zIndex: 3
            }],
			tickInterval: tickItv,
			max : tickMax,
			min : tickMin,
			labels: {
				style: {
				  fontSize: '10px'
				}
			}
        },
				
		plotOptions: {
			spline: {
				//lineWidth : 5,
				dataLabels: {
					enabled: false,
					formatter : function(){
						var yLabel = this.y;
						if(this.y > 0) yLabel = '+' + this.y;
						return '[' + this.x + ' , ' + yLabel + ']';
					},
					style : {
						fontSize : lblFontSize
					}
				},
				marker: {
				 enabled: false
			   }
			}
		},
		
		tooltip: {
            //enabled: false
		pointFormat : '<b>{point.y}</b>', 
		enabled: true
        },
		
        series: [{
			animation: false,
			turboThreshold: 0, 
			type: 'spline',
			data : graphData
		}]
    });
}

function ajaxFunctionGetGraph(param,koroSeq){
	var retKbn = '';
	$.ajax({
		async : true,
		url: '../Magic33Scripts/MGrqispi.dll',
		data : param,
		dataType:'xml',
		type : 'POST',
		scriptCharset: 'utf-8',
		success : function(xml){
			var ret = $(xml).find('ret').text();
			retKbn = ret;
			var msg = $(xml).find('message').text();
			if(ret !== 'I001'){
				alert(msg);
			}
			retData = xml;
			docXml = retData;
		},
		error : function(XMLHttpRequest, textStatus, errorThrown){
			alert('System Error');
			window.location = "../webnais/pilot/index.html";
		}
	}).done(function(){
		if(retKbn === 'I001'){
			if(docXml !== ""){
				var lineTag = [];
				lineTag[0] = 'line';
				lineTag[1] = 'tyoryuline';
				lineTag[2] = 'tyokoline';
				lineTag[3] = 'headline';
				
				var subLineTag = [];
				subLineTag[0] = 'joholine'
			
				var graphDataTyoryu = new Array();
				var graphDataTyoko = new Array();
				
				var getData = xmlToMultiStageArray(docXml,'data',lineTag,subLineTag);
				var johoTitle = getData[0].headline[0].headTitle;
				var dispDateStr = getData[0].headline[0].dispDateStr;
				var ssTimeStr = getData[0].headline[0].ssTimeStr;
				
				var tyoryuBikoTOP = $(docXml).find('tyoryuBikoTOP').text();
				var tyoryuBikoBTM = $(docXml).find('tyoryuBikoBTM').text();
				var tyoryuBiko = $(docXml).find('tyoryuBiko').text();
				var tyokoBiko = $(docXml).find('tyokoBiko').text();
				docData[koroSeq] = getData[0].line;
				tyoryuData[koroSeq] = getData[0].tyoryuline;
				tyokoData[koroSeq] = getData[0].tyokoline;
				tyokoUnderFlgData[koroSeq] = false;
				for(var i=0; i<tyokoData[koroSeq].length; i++){
					if(tyokoData[koroSeq][i].shioVal.indexOf('-') > -1){
						tyokoUnderFlgData[koroSeq] = true;
					}
				}
				
				johoData[koroSeq] = getData[0].headline[0].joholine;
				johoTitleData[koroSeq] = johoTitle;
				
				graphDataTyoryu = createTyoryuDataArr(koroSeq);
				graphDataTyoko = createTyokoDataArr(koroSeq);
				
				var koroNMFlg = johoTitle.indexOf('来島');
				
				var targetDiv ='';
				var targetTblDiv ='';
				
				var targetJohoDiv = '#div_joho_' + koroSeq;				
				createJohoArea(targetJohoDiv,johoData[koroSeq],johoTitle,koroSeq,dispDateStr,ssTimeStr)
				
				if(graphDataTyoryu[0].length > 0) {
					targetDiv = '#graph_' + koroSeq + '_tyoryu';
					targetTblDiv = '#div_tbl_' + koroSeq + '_tyoryu';
					//var toggleText = $('a[data-target="'+targetDiv+'"]').text();
					//$('a[data-target="'+targetDiv+'"]').text(toggleText+' '+tyoryuBiko);
					$('#spnTyoryuTOP_'+koroSeq).text(tyoryuBikoTOP);
					$('#spnTyoryuBTM_'+koroSeq).text(tyoryuBikoBTM);
					
					createGraph(koroSeq,targetDiv,graphDataTyoryu[0],graphDataTyoryu[1],'Tyoryu',koroNMFlg);
					$(targetTblDiv).children('div').empty();
					createTyoryuTable(targetTblDiv,tyoryuData[koroSeq]);
					createTimeTable(targetTblDiv,graphDataTyoryu[2],graphDataTyoryu[3],graphDataTyoryu[4]);
				}else {
					$('div.divKoroSet[data-koroSeq="'+koroSeq+'"][data-graphType="1"]').remove();
				}
				if(graphDataTyoko[0].length > 0) {
					targetDiv = '#graph_' + koroSeq + '_tyoko';
					targetTblDiv = '#div_tbl_' + koroSeq + '_tyoko';
					//var toggleText = $('a[data-target="'+targetDiv+'"]').text();
					//$('a[data-target="'+targetDiv+'"]').text(toggleText+' '+tyokoBiko);
					createGraph(koroSeq,targetDiv,graphDataTyoko[0],graphDataTyoko[1],'Tyoko',koroNMFlg);
					$(targetTblDiv).children('div').empty();
					createTyokoTable(targetTblDiv,tyokoData[koroSeq]);
					createTimeTable(targetTblDiv,graphDataTyoko[2],graphDataTyoko[3],graphDataTyoko[4]);
				}else {
					$('div.divKoroSet[data-koroSeq="'+koroSeq+'"][data-graphType="2"]').remove();
				}
			}
			
			if(callCount+1 < koroArray.length){			
				callCount = callCount + 1;
				callGraphData(callCount);
			}else {
				$('input').prop('disabled',false);
				$('select').prop('disabled',false);
			}
			
			$('#aTyoryuGraphToggle_'+koroSeq).text($('#aTyoryuGraphToggle_'+koroSeq).text()+' '+tyoryuBiko);
			$('#aTyoryuGraphToggle_'+koroSeq).css('display','block');
			$('#btnTyoryuGraphToggle_'+koroSeq).css('display','block');
			//$('#btnTyoryuListToggle_'+koroSeq).css('display','block');
			$('#slct_time_tyoryu_'+koroSeq).css('display','block');
			
			$('#aTyokoGraphToggle_'+koroSeq).text($('#aTyokoGraphToggle_'+koroSeq).text()+' '+tyokoBiko);
			$('#aTyokoGraphToggle_'+koroSeq).css('display','block');		
			$('#btnTyokoGraphToggle_'+koroSeq).css('display','block');
			//$('#btnTyokoListToggle_'+koroSeq).css('display','block');
			$('#slct_time_tyoko_'+koroSeq).css('display','block');
			
			$('#aGoTotTop_'+koroSeq).css('display','block');
		}else {
			$('input').prop('disabled',false);
			$('select').prop('disabled',false);
		}
	});
}

function getGraphData(koroKBN,koroName,targetDateKbn,koroSeq){
	$("#hdnSearchKoroSeq").val($("#hdnSearchKoroSeq").val()+koroSeq+':');
	$("#hdnSearchKoroName").val($("#hdnSearchKoroName").val()+koroName+':');
	$("#hdnSearchKoroDisp").val($("#hdnSearchKoroDisp").val()+targetDateKbn+':');
	
	var chkDoujiVal = 0;	
	if($('#chkSearchToDouji').prop('checked')) chkDoujiVal = 1;
	var kyodoYMD = $('#inpSearchYM').val() + '/' + $('#inpSearchD').val();
	
	var param = {
		'appname':'NAIS3WEB',
		'prgname':'D301',
		'ssid': $('#ssid').val(),
		'IMO_No' : $('#inpSearchIMONo').val(),
		'DW' : $('#inpSearchDW').val(),
		'LOA' : $('#inpSearchLOA').val(),
		'DFF' : $('#inpSearchDFF').val(),
		'DFA' : $('#inpSearchDFA').val(),
		'josenCdA' : $('#inpSearchFromA').val(),
		'josenCdB' : $('#inpSearchFromB').val(),
		'josenSetsugangen' : $('#slctSearchFromSetsugangen').val(),
		'gesenCdA' : $('#inpSearchToA').val(),
		'gesenCdB' : $('#inpSearchToB').val(),
		'gesenSetsugangen' : $('#slctSearchToSetsugangen').val(),
		'Douji' : $('#chkSearchToDouji').prop('checked'),
		'targetDate' : kyodoYMD,
		'targetDateKbn' : targetDateKbn,
		//'koroKBN' : koroKBN, 2015/10/06 削除
		'koroName' : koroName,
		//'arguments':'ssid,IMO_No,DW,LOA,DFF,DFA,josenCdA,josenCdB,josenSetsugangen,gesenCdA,gesenCdB,gesenSetsugangen,Douji,targetDate,targetDateKbn,koroKBN,koroName'
		'arguments':'ssid,IMO_No,DW,LOA,DFF,DFA,josenCdA,josenCdB,josenSetsugangen,gesenCdA,gesenCdB,gesenSetsugangen,Douji,targetDate,targetDateKbn,koroName'
	};

	ajaxFunctionGetGraph(param,koroSeq);
}

function getTimeiData(timeiCdA,timeiCdB){
	var param = {
		'appname':'NAIS3WEB',
		'prgname':'W522',
		'ssid': $('#ssid').val(),		
		'timeiCdA' : timeiCdA,
		'timeiCdB' : timeiCdB,
		'arguments':'ssid,timeiCdA,timeiCdB'
	};

	return ajaxFunction(param,'1');
}

function changeTableSelect(koroSeq,dataType){
	var targetDiv = '#graph_' + koroSeq;
	var targetTblDiv = '#div_tbl_' + koroSeq;
	
	var graphDataTyoryu = new Array();
	var graphDataTyoko = new Array();
	
	if(dataType === 'tyoryu'){
		targetDiv = targetDiv + '_tyoryu';
		targetTblDiv = targetTblDiv + '_tyoryu';
		
		graphDataTyoryu = createTyoryuDataArr(koroSeq);
		$(targetTblDiv).children('div').empty();
		createTyoryuTable(targetTblDiv,tyoryuData[koroSeq]);
		createTimeTable(targetTblDiv,graphDataTyoryu[2],graphDataTyoryu[3],graphDataTyoryu[4]);
	}else {
		targetDiv = targetDiv + '_tyoko';
		targetTblDiv = targetTblDiv + '_tyoko';
		
		graphDataTyoko = createTyokoDataArr(koroSeq);
		$(targetTblDiv).children('div').empty();
		createTyokoTable(targetTblDiv,tyokoData[koroSeq]);
		createTimeTable(targetTblDiv,graphDataTyoko[2],graphDataTyoko[3],graphDataTyoko[4]);
	}
}

var printWin;
function Printour(){
	printWin = window.open();
	
	// 航路数取得
	var writeKoro = $('div.JOHO').length;
	var createHTML;
	var param = {
		'appname':'NAIS3WEB',
		'prgname':'D302',
		'ssid': $('#ssid').val(),
		'KoroCunt' : writeKoro,
		'arguments':'ssid,KoroCunt'
	};
	
	$.ajax({
		async : true,
		cache : false,
		url: '../Magic33Scripts/MGrqispi.dll',
		data : param,
		dataType:'html',
		type : 'GET',
		scriptCharset: 'utf-8',
		success : function(retHtml){
			createHTML = retHtml;
		},
		error : function(XMLHttpRequest, textStatus, errorThrown){
			alert('System Error');
			window.location = "../webnais/pilot/index.html";
		}
	}).done(function(){
		var printDoc = printWin.document;
		printDoc.write(createHTML);
		var printBody = printDoc.body;
		
		$(printDoc.body).html(createPrintHTML());
		
		$('.printGraph').remove();
	})
}

//TIDE印刷(PDF)
var PDFWin;
function TidePrt(PrtType){
	if(PDFWin && !PDFWin.closed) PDFWin.close();
	//PDFWin = window.open("","潮流・潮汐表印刷",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=0,menubar=0,left=100,top=60,width=800,height=550,');
	PDFWin = window.open("","Print",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=0,menubar=0,left=100,top=60,width=800,height=550');
	
	var koroCnt = 0;
	var koroIDStr = $("#hdnSearchKoroSeq").val();
	var koroNameStr = $("#hdnSearchKoroName").val();
	var koroDispType = $("#hdnSearchKoroDisp").val();
	
	var tyoryuGraphDisp = '';
	var tyoryuListDisp = '';	
	var tyoryuListType = '';
	
	var tyokoGraphDisp = '';
	var tyokoListDisp = '';	
	var tyokoListType = '';
	
	$('div.JOHO').each(function(){
		koroCnt = koroCnt +1;
		var thisKoroSeq = $(this).find('span.JOHO').attr('data-koroseq');		
		
		if($(this).find('div.divKoroSet[data-graphtype="1"]').length === 0){
			tyoryuGraphDisp = tyoryuGraphDisp + '9:';
			tyoryuListDisp = tyoryuListDisp + '9:';
			tyoryuListType = tyoryuListType + '9:';
		}
		if($(this).find('div.divKoroSet[data-graphtype="2"]').length === 0){
			tyokoGraphDisp = tyokoGraphDisp + '9:';
			tyokoListDisp = tyokoListDisp + '9:';
			tyokoListType = tyokoListType + '9:';
		}
		
		$(this).find('div.divKoroSet').each(function(){
			switch($(this).attr('data-graphtype')){
				case '1' :
					//グラフ表示取得
					if($(this).find('div.graphSet').length === 0){
						//グラフがない場合は9をセット
						tyoryuGraphDisp = tyoryuGraphDisp + '9:';
					}else {
						if($(this).find('div.graphSet').css('display') === 'none'){
							tyoryuGraphDisp = tyoryuGraphDisp + '0:';
						}else {
							tyoryuGraphDisp = tyoryuGraphDisp + '1:';
						}
					}				
					
					//リスト表示取得
					if($(this).find('div.listSet').length === 0){
						tyoryuListDisp = tyoryuListDisp + '9:';
						tyoryuListType = tyoryuListType + '9:';
					}else {
						if($(this).find('div.listSet').css('display') === 'none'){
							tyoryuListDisp = tyoryuListDisp + '0:';
						}else {
							tyoryuListDisp = tyoryuListDisp + '1:';
						}
						tyoryuListType = tyoryuListType + $(this).find('select').val() + ':';
					}
					break;
					
				case '2' :
					//グラフ表示取得
					if($(this).find('div.graphSet').length === 0){
						//グラフがない場合は9をセット
						tyokoGraphDisp = tyokoGraphDisp + '9:';
					}else {
						if($(this).find('div.graphSet').css('display') === 'none'){
							tyokoGraphDisp = tyokoGraphDisp + '0:';
						}else {
							tyokoGraphDisp = tyokoGraphDisp + '1:';
						}
					}				
					
					//リスト表示取得
					if($(this).find('div.listSet').length === 0){
						tyokoListDisp = tyokoListDisp + '9:';
						tyokoListType = tyokoListType + '9:';
					}else {
						if($(this).find('div.listSet').css('display') === 'none'){
							tyokoListDisp = tyokoListDisp + '0:';
						}else {
							tyokoListDisp = tyokoListDisp + '1:';
						}
						tyokoListType = tyokoListType + $(this).find('select').val() + ':';
					}
					break;
			}
		})
	})
	
	var createHTML;
	var param = {
		'appname':'NAIS3WEB',
		'prgname':'D310',
		'ssid': $('#ssid').val(),
		'prtType':PrtType,
		'iraiRbn':'',
		'retryCnt':0,		
		'koroCnt':koroCnt,
		'koroNameStr':koroNameStr,
		'koroDispType':koroDispType,
		'tyoryuGraphDisp':tyoryuGraphDisp,
		'tyoryuListDisp':tyoryuListDisp,
		'tyoryuListType':tyoryuListType,
		'tyokoGraphDisp':tyokoGraphDisp,
		'tyokoListDisp':tyokoListDisp,
		'tyokoListType':tyokoListType,
		'arguments':'ssid,prtType,iraiRbn,retryCnt,koroCnt,koroNameStr,koroDispType,tyoryuGraphDisp,tyoryuListDisp,tyoryuListType,tyokoGraphDisp,tyokoListDisp,tyokoListType'
	};
	
	$.ajax({
		async : true,
		cache : false,
		url: '../Magic33Scripts/MGrqispi.dll',
		data : param,
		dataType:'text',
		type : 'GET',
		scriptCharset: 'utf-8',
		success : function(retHtml){
			createHTML = retHtml;
		},
		error : function(XMLHttpRequest, textStatus, errorThrown){
			alert('System Error');
			window.location = "../webnais/pilot/index.html";
		}
	}).done(function() {
		var PDFDoc = PDFWin.document;
		PDFDoc.write(createHTML);
		PDFWin.focus();
	})
}

var createGraphHTML = '';
function createPrintHTML(){
	
	var retHTML = '';
	var printCnt = 0;
	var totalPrintTarget = $('div.divKoroSet').length;
	
	$('div.JOHO').each(function(i){
		var $johoKoroSpn = $($(this).find('span.JOHO'));
		var $DispTimeSpn = $($(this).find('span.DispDate'));
		var $SunsetSunriseSpn = $($(this).find('span.SunsetSunrise'));
		
		var johoKoroSeq = $johoKoroSpn.attr('data-koroSeq');
		retHTML = retHTML + '<div class="print_div_GROUP">';
		retHTML = retHTML + '<div style="margin:10px;">';
		
		// 航路名作成
		retHTML = retHTML
				  +'<div style="float:left"><span class="print_spn_title">'+$johoKoroSpn.text()+'</span></div>'
				  +'<div style="float:right">'
				  	+'<span style="display:block;float:left;">'+$DispTimeSpn.text()+'</span>'
				  	+'<span style="display:block;float:left;margin-left:15px;">'+$SunsetSunriseSpn.text()+'</span>'
				  +'</div>'
				  +'<div style="clear:both;"></div>';
		
		// 航路情報TABLE作成
		var tblJohoHTML = '<table class="print_tbl_JOHO">'
		var johoDataKoro = johoData[johoKoroSeq];
		for(var i=0; i<johoDataKoro.length; i++){
			tblJohoHTML = tblJohoHTML +
					'<tr>'+
						'<td rowspan="2" style="vertical-align:top;">'+johoDataKoro[i].johoBiko+'</td>'+
						'<td>'+johoDataKoro[i].johoFT1+'</td>'+
						'<td>'+johoDataKoro[i].johoFT2+'</td>'+
					'</tr>' +
					'<tr>'+
						'<td>'+johoDataKoro[i].johoFT3+'</td>'+
						'<td>'+johoDataKoro[i].johoFT4+'</td>'+
					'</tr>'
		}
		tblJohoHTML = tblJohoHTML + '</table>';
		
		$(this).find('div.divKoroSet').each(function(){
			printCnt = printCnt + 1;
			var koroSeq = $(this).attr('data-koroSeq');
			var graphType = $(this).attr('data-graphType');
			var titleSpan = '';
			if(graphType === '1'){
				titleSpan = '#aTyoryuGraphToggle_'+koroSeq;
			}else {
				titleSpan = '#aTyokoGraphToggle_'+koroSeq;
			}
			
			var graphID = 'print_graph_'+koroSeq+'_'+graphType; 
			
			var tblGraphHTML = '';
			
			createPrintGraph(koroSeq,graphType);
			
			var graphH = 190;
			var graphW = 360;
			var ua = navigator.userAgent; // ユーザーエージェントを代入
			if(ua.match("MSIE") || ua.match("Trident")) {
				 graphH = 200;
				 graphW = 375;
			}
			
			if($(this).find('span.spnTyoryuTOP')){
				tblGraphHTML = 	'<tr>' +
									'<td colspan="3">' +
										$(titleSpan).text() +
									'</td>' +
								'</tr>'+
								'<tr>' +
									'<td style="height:20px;width:35px;vertical-align:top;">'+$(this).find('span.spnTyoryuTOP').text()+'</td>'+
									'<td rowspan="3">'+
										'<div class="printGraph" id="'+graphID+'" graphType="'+graphType+'" style="width:'+graphW+'px; height: '+graphH+'px;">'+
											document.getElementById(graphID).innerHTML +
										'</div>'+
									'</td>'+
									'<td rowspan="3" style="width: 400px; height: '+graphH+'px;">'+
										'<div>'+
											tblJohoHTML+
										'</div>'+
									'</td>'+
								'</tr>'+
								'<tr>'+
									'<td style="height:'+(graphH-40)+'px;width:35px;">&nbsp;</td>'+
									'<td>&nbsp;</td>'+
								'</tr>'+
								'<tr>'+
									'<td style="height:20px;width:35px;vertical-align:top;">'+$(this).find('span.spnTyoryuBTM').text()+'</td>'+
									'<td>&nbsp;</td>'+
								'</tr>';				
			}else {
				tblGraphHTML = 	'<tr>' +
									'<td colspan="3">' +
										$(titleSpan).text() +
									'</td>' +
								'</tr>'+
								'<tr>' +
									'<td style="height:20px;width:35px;">&nbsp;</td>'+
									'<td rowspan="3">'+
										'<div class="printGraph" id="'+graphID+'" graphType="'+graphType+'" style="width:'+graphW+'px; height: '+graphH+'px;">'+
											document.getElementById(graphID).innerHTML +
										'</div>'+
									'</td>'+
									'<td rowspan="3">'+
										'<div>'+
											tblJohoHTML+
										'</div>'+
									'</td>'+
								'</tr>'+
								'<tr>'+
									'<td style="height:'+(graphH-40)+'px;width:35px;">&nbsp;</td>'+
									'<td>&nbsp;</td>'+
								'</tr>'+
								'<tr>'+
									'<td style="height:20px;width:35px;">&nbsp;</td>'+
									'<td>&nbsp;</td>'+
								'</tr>';
			}
			tblJohoHTML = '';
			tblGraphHTML = '<table class="print_tbl_GRAPH">' + tblGraphHTML + '</table>';
			retHTML = retHTML + tblGraphHTML;
			retHTML = retHTML + createPrintTimeTable(koroSeq,graphType);
			if(printCnt % 3 === 0 && totalPrintTarget !== printCnt){
				retHTML = retHTML + '<div style="page-break-before: always;"></div>';
			}
		})
		
		retHTML = retHTML + '</div></div>';
	})
		
	return 	retHTML;
}


function createPrintTimeTable(koroSeq,graphType){
	var hourArryTitle = new Array();
	var hourArry00 = new Array();
	var hourArry10 = new Array();
	var hourArry20 = new Array();
	var hourArry30 = new Array();
	var hourArry40 = new Array();
	var hourArry50 = new Array();
	
	var rowCnt = 0;
	var colCnt = 0;
	for(var i=0; i<docData[koroSeq].length; i++){
		if(docData[koroSeq][i].graphType === graphType && docData[koroSeq][i].flg10M === 'True'){
			switch(docData[koroSeq][i].timeVal.substr(3,2)){
				case '00' :
					hourArryTitle.push(docData[koroSeq][i].timeVal.substr(0,2));
					hourArry00.push([docData[koroSeq][i].printVal,docData[koroSeq][i].tdColor]);
					break;
				
				case '10' :
					hourArry10.push([docData[koroSeq][i].printVal,docData[koroSeq][i].tdColor]);
					break;
				
				case '20' :
					hourArry20.push([docData[koroSeq][i].printVal,docData[koroSeq][i].tdColor]);
					break;
				
				case '30' :
					hourArry30.push([docData[koroSeq][i].printVal,docData[koroSeq][i].tdColor]);
					break;
					
				case '40' :
					hourArry40.push([docData[koroSeq][i].printVal,docData[koroSeq][i].tdColor]);
					break;
				
				case '50' :
					hourArry50.push([docData[koroSeq][i].printVal,docData[koroSeq][i].tdColor]);
					break;
			}
		}
	}
	
	var htmlTiemTitle = '<tr><td>&nbsp;</td>';
	var htmlTiem00 = '<tr><td class="HEAD">00</td>';
	var htmlTiem10 = '<tr><td class="HEAD">10</td>';
	var htmlTiem20 = '<tr><td class="HEAD">20</td>';
	var htmlTiem30 = '<tr><td class="HEAD">30</td>';
	var htmlTiem40 = '<tr><td class="HEAD">40</td>';
	var htmlTiem50 = '<tr><td class="HEAD">50</td>';
	
	for(var i=0; i<hourArryTitle.length; i++){
		htmlTiemTitle = htmlTiemTitle + '<td class="HEAD">' + hourArryTitle[i] + '</td>';		
		htmlTiem00 = htmlTiem00 + '<td style="color:'+hourArry00[i][1]+'">' + hourArry00[i][0] + '</td>';
		htmlTiem10 = htmlTiem10 + '<td style="color:'+hourArry10[i][1]+'">' + hourArry10[i][0] + '</td>';
		htmlTiem20 = htmlTiem20 + '<td style="color:'+hourArry20[i][1]+'">' + hourArry20[i][0] + '</td>';
		htmlTiem30 = htmlTiem30 + '<td style="color:'+hourArry30[i][1]+'">' + hourArry30[i][0] + '</td>';
		htmlTiem40 = htmlTiem40 + '<td style="color:'+hourArry40[i][1]+'">' + hourArry40[i][0] + '</td>';
		htmlTiem50 = htmlTiem50 + '<td style="color:'+hourArry50[i][1]+'">' + hourArry50[i][0] + '</td>';
	}
	
	htmlTiemTitle = htmlTiemTitle + '<tr>';
	htmlTiem00 = htmlTiem00 + '<tr>';
	htmlTiem10 = htmlTiem10 + '<tr>';
	htmlTiem20 = htmlTiem20 + '<tr>';
	htmlTiem30 = htmlTiem30 + '<tr>';
	htmlTiem40 = htmlTiem40 + '<tr>';
	htmlTiem50 = htmlTiem50 + '<tr>';
	
	var retHTML = '<table class="print_tbl_LIST">' + htmlTiemTitle + htmlTiem00 + htmlTiem10 + htmlTiem20 + htmlTiem30 + htmlTiem40 + htmlTiem50 + '</table>';
	return retHTML
}

function createPrintGraph(koroSeq,graphType){
	var graphH = 190;
	var graphW = 360;
	var ua = navigator.userAgent; // ユーザーエージェントを代入
	if(ua.match("MSIE") || ua.match("Trident")) {
		 graphH = 200;
		 graphW = 375;
	}
	
	var graphID = 'print_graph_'+koroSeq+'_'+graphType; 
	var addHTML = '<div class="printGraph" id="'+graphID+'" graphType="'+graphType+'" style="width:'+graphW+'px; height: '+graphH+'px; dispalay:none;"></div>';
	$('#divDocument').append(addHTML);
	var targetGraphDiv = '#print_graph_'+koroSeq+'_'+graphType;
	
	var graphData;
	if(graphType === '1'){
		graphNM = 'Tyoryu';
		graphData = createTyoryuDataArr(koroSeq);
	}else {
		graphNM = 'Tyoko';
		graphData = createTyokoDataArr(koroSeq);
	}
	
	var koroNMFlg = johoTitleData[koroSeq].indexOf('来島');
	
	createGraph(koroSeq,targetGraphDiv,graphData[0],graphData[1],graphNM,koroNMFlg,true);
	
}

function DispStatus(form)
        {
        status = ("");
        }
//支援情報
function SienJoho(){
	var maeFunk1     = $('#hdnMaeFunk').val();
	var maeKyoten    = $('#hdnMaeKyoten').val();	
	var maeDateym  = $('#hdnMaeDateYM').val();
	var maeDated   = $('#hdnMaeDateD').val();
	var kadoFunk = $('#hdnKadoFunk').val();
	var kadoHaijo = $('#hdnKadoHaijo').val();
	var kadoRigyo = $('#hdnKadoRigyo').val();
	var kadoShikaku = $('#hdnKadoShikaku').val();
	var maeMinato    = $('#hdnMaeMinatoCd').val();
	var returnPG = $('#RETURN_PG').val();
	var order_no = $('#ORDER_NO').val();
	$('#prgname').val('W130');	
	$('#param1').val(maeFunk1);
	$('#param2').val(maeKyoten);
	$('#param3').val(maeDateym);
	$('#param4').val(maeDated);
	$('#param5').val(order_no);
	$('#param6').val(returnPG);
	$('#param7').val('W110');
	$('#param8').val(kadoFunk);
	$('#param9').val(kadoHaijo);
	$('#param10').val(kadoRigyo);
	$('#param11').val(kadoShikaku);
	$('#param12').val(maeMinato);
	$('#menuForm').submit();
	
	// 支援情報を呼ぶ
	/*
	funk1     = form.FUNK1.value
	kyoten    = form.KYOTEN.value
	r_dateym  = form.R_DATEYM.value
	r_dated   = form.R_DATED.value
	order_no  = form.ORDER_NO.value

	parent.location.replace("/Magic33Scripts/MGrqispi.dll?APPNAME=<!$MG_appname>&PRGNAME=W130&ARGUMENTS=-A<!$MG_appname>,-A<!$MG_user>,-A"+ "1" 
	+ ",-A" + kyoten + ",-A" + r_dateym + ",-A" + r_dated + ",-A" + order_no + ",-AW120,-A"
	+ "<!$MG_kado_pgm_id>,-A<!$MG_kado_funk1>,-A<!$MG_kado_haijo>,-A<!$MG_kado_rigyo>,-A<!$MG_kado_shikaku>,-A<!$MG_minato_cd>");
	*/
	//parent.location.replace("/Magic33Scripts/MGrqispi.dll?APPNAME=<!$MG_appname>&PRGNAME=W082&ARGUMENTS=-A<!$MG_appname>,-A<!$MG_user>,-A" + order_no);
}

function callSetOption(){
	if(!$('#chbGraphDisp').prop('checked') && !$('#chbListDisp').prop('checked')){
		alert('グラフか表のいずれかの表示を選択をしてください');
	}else {
		// 表示オプション保存
		var param = {
			'appname':'NAIS3WEB',
			'prgname':'D303',
			'ssid': $('#ssid').val(),
			'GraphDisp' : $('#chbGraphDisp').prop('checked'),
			'ListDisp' : $('#chbListDisp').prop('checked'),
			'ListInitVal' : $('#slctListTimeVal').val(),
			'arguments':'ssid,GraphDisp,ListDisp,ListInitVal'
		};
		
		$.ajax({
			async : true,
			cache : false,
			url: '../Magic33Scripts/MGrqispi.dll',
			data : param,
			dataType:'xml',
			type : 'POST',
			scriptCharset: 'utf-8',
			success : function(xml){
				alert($(xml).find('message').text());
			},
			error : function(XMLHttpRequest, textStatus, errorThrown){
				alert('System Error');
				window.location = "../webnais/pilot/index.html";
			}
		})
	}
}

function resetDisp(){
	
	if(!$('#chbGraphDisp').prop('checked') && !$('#chbListDisp').prop('checked')){
		alert('グラフか表のいずれかの表示を選択をしてください');
	}else {
		if(!$('#chbGraphDisp').prop('checked')){
			$('div.graphSet').hide();
			$('input[type="button"].ToggleGraph').each(function(){
				$(this).val('グラフ表示');
			});
		}else {
			$('div.graphSet').show();
			$('input[type="button"].ToggleGraph').each(function(){
				$(this).val('グラフ非表示');
			});
		}
		$('select.TABLE').each(function(){
			$(this).val($('#slctListTimeVal').val());
			var koroSEQ = $(this).attr('data-koroSeq');
			var dataType = $(this).attr('data-type');
			changeTableSelect(koroSEQ,dataType);
		});
	}
}

function setKoroCheck(){
	
	var retConfirm = true;
	
	if(searchChangeFLG){
		if(!confirm('嚮導条件の変更は無視されます。\nよろしいですか？')){
			retConfirm = false;
		}else {
			$('#inpSearchDW').val(initDW);
			$('#inpSearchLOA').val(initLOA);
			$('#inpSearchDFF').val(initDFF);
			$('#inpSearchDFA').val(initDFA);
			$('#inpSearchFromA').val(initFromA);
			$('#inpSearchFromB').val(initFromB);
			$('#lblFromName').text(initFromName);
			$('#slctSearchFromSetsugangen').val(initFromSetsugangen);	
			$('#inpSearchToA').val(initToA);
			$('#inpSearchToB').val(initToB);
			$('#lblToName').text(initToName);
			$('#slctSearchToSetsugangen').val(initToSetsugangen);
			$('#chkSearchToDouji').prop('checked',initToDouji);
			$('#inpSearchYM').val(initYM);
			$('#inpSearchD').val(initD);
			searchChangeFLG = false;
		}
	}
	
	if(retConfirm){
		$('input').prop('disabled',true);
		$('select').prop('disabled',true);
		
		// 航路数取得
		//var koroCnt = 0;
		var koroPKBNStr='';
		var koroPIDStr = '';
		var koroNMStr = '';
		var koroChkStr = '';
		
		$('div.KORO').each(function(){
			if($(this).find('input[type="checkbox"].KORO')){
				//koroCnt = koroCnt + 1;
				koroPKBNStr= koroPKBNStr + $($(this).find('input.koroPKBN')).val() + ';';
				koroPIDStr = koroPIDStr + $($(this).find('input.koroPID')).val() + ';';
				koroNMStr = koroNMStr + $($(this).find('input.koroName')).val() + ';';
				koroChkStr = koroChkStr + $($(this).find('input[type="checkbox"].KORO')).prop('checked') + ';';
			}
		})
		
		var koroCnt = countKoro();
		if(koroCnt > 0 ){
			var param = {
				'appname':'NAIS3WEB',
				'prgname':'D304',
				'ssid': $('#ssid').val(),
				'KoroCunt' : koroCnt,
				'PKBNStr' : koroPKBNStr,
				'PIDStr' : koroPIDStr,
				'NMStr' : koroNMStr,
				'ChkStr' : koroChkStr,
				'arguments':'ssid,KoroCunt,PKBNStr,PIDStr,NMStr,ChkStr'
			};
			
			$.ajax({
				async : true,
				cache : false,
				url: '../Magic33Scripts/MGrqispi.dll',
				data : param,
				dataType:'xml',
				type : 'POST',
				success : function(xml){			
				},
				error : function(XMLHttpRequest, textStatus, errorThrown){
					alert('System Error');
					window.location = "../webnais/pilot/index.html";
				}
			}).done(function(){			
				setupGraph();
			})
		}else {
			alert('対象となる航路がありません');
			$('input').prop('disabled',false);
			$('select').prop('disabled',false);
		}
	}
	
}

function callReCal(){
	kyoten    = $('#KYOTEN').val();
	
	r_dateym  = $('#R_DATEYM').val();
	r_dated   = $('#R_DATED').val();
	/*
	r_dateym  = $('#inpSearchYM').val();
	r_dated   = $('#inpSearchD').val();
	*/
	order_no  = $('#ORDER_NO').val();
	var IMO_NO =  $('#inpSearchIMONo').val();
	var DW =  $('#inpSearchDW').val().replace(/,/g,"");
	var LOA = $('#inpSearchLOA').val().replace(/,/g,"");
	var DFF = $('#inpSearchDFF').val().replace(/,/g,"");
	var DFA = $('#inpSearchDFA').val().replace(/,/g,"");
	var FromA = $('#inpSearchFromA').val();
	var FromB = $('#inpSearchFromB').val();
	var FromSetsugangen = $('#slctSearchFromSetsugangen').val()
	var ToA = $('#inpSearchToA').val();
	var ToB = $('#inpSearchToB').val();
	var ToSetsugangen = $('#slctSearchToSetsugangen').val();
	var chkDoujiVal = 0;
	if($('#chkSearchToDouji').prop('checked')) chkDoujiVal = 1;
	var kyodoYMD = $('#inpSearchYM').val() + '/' + $('#inpSearchD').val();
	/*
	parent.location.replace("/Magic33Scripts/MGrqispi.dll?APPNAME=<!$MG_appname>&PRGNAME=D300&ARGUMENTS=-A<!$MG_appname>,-A<!$MG_user>,-A" + "1"
		+",-A" + kyoten +",-A" + r_dateym +",-A" + r_dated +",-A" + order_no + ',-A' + IMO_NO + ',-A' + DW + ',-A' + LOA	+',-A' + DFF + ',-A' + DFA
		+ ',-A' + FromA + ',-A' + FromB + ',-A' + FromSetsugangen +',-A' + ToA +',-A' + ToB + ',-A' + ToSetsugangen + ',-A' + chkDoujiVal + ',-A' + kyodoYMD
		+ ",-AW120,-A"	+ "<!$MG_kado_pgm_id>,-A<!$MG_kado_funk1>,-A<!$MG_kado_haijo>,-A<!$MG_kado_rigyo>,-A<!$MG_kado_shikaku>,-A<!$MG_minato_cd>");
	*/
	var maeFunk1     = $('#hdnMaeFunk').val();
	var maeKyoten    = $('#hdnMaeKyoten').val();	
	var maeDateym  = $('#hdnMaeDateYM').val();
	var maeDated   = $('#hdnMaeDateD').val();
	var kadoFunk = $('#hdnKadoFunk').val();
	var kadoHaijo = $('#hdnKadoHaijo').val();
	var kadoRigyo = $('#hdnKadoRigyo').val();
	var kadoShikaku = $('#hdnKadoShikaku').val();
	var maeMinato    = $('#hdnMaeMinatoCd').val();
	var returnPG = $('#RETURN_PG').val();
	$('#prgname').val('D300');
	$('#param1').val(order_no);
	$('#param2').val(returnPG);
	$('#param3').val("1");
	$('#param4').val(maeFunk1);
	$('#param5').val(maeKyoten);
	$('#param6').val(maeDateym);
	$('#param7').val(maeDated);
	$('#param8').val(kadoFunk);
	$('#param9').val(kadoHaijo);
	$('#param10').val(kadoRigyo);
	$('#param11').val(kadoShikaku);
	$('#param12').val(maeMinato);
	$('#param13').val(IMO_NO);
	$('#param14').val(DW);
	$('#param15').val(LOA);
	$('#param16').val(DFF);
	$('#param17').val(DFA);
	$('#param18').val(FromA);
	$('#param19').val(FromB);
	$('#param20').val(FromSetsugangen);
	$('#param21').val(ToA);
	$('#param22').val(ToB);
	$('#param23').val(ToSetsugangen);
	$('#param24').val(chkDoujiVal);
	$('#param25').val(kyodoYMD);
	$('#menuForm').submit();
}

function callMinato(inpCdA,inpCdB,lblNm,flgSetsugangen,flgDouji){	
	targetInpCdA = inpCdA;
	targetInpCdB = inpCdB;
	targetLblNm = lblNm;
	targetFlgSetsugangen = flgSetsugangen;
	targetFlgDouji = flgDouji;
	/*
	window.open("/Magic33Scripts/MGrqispi.dll?APPNAME=<!$MG_appname>&PRGNAME=W520&ARGUMENTS=-A<!$MG_appname>,-A<!$MG_user>,-A"+inpCdA+",-A"+inpCdB+",-A"+lblNm+",-A"+flgSetsugangen+",-A"+flgDouji,
	+ "TIMEI_NO",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=1,menubar=0,left=0,top=0,width=720,height=600,');
	*/
	var minatoParam = {
		'appname':'NAIS3WEB',
		'prgname':'W520',
		'ssid': $('#ssid').val(),
		'targetA': inpCdA,
		'targetB': inpCdB,
		'targetC' : lblNm,
		'targetD' : flgSetsugangen,
		'targetE' : flgDouji,
		'arguments':'ssid,targetA,targetB,targetC,targetD,targetE'
	};
	
	$.ajax({
		async : false,
		url: ajaxURL,
		data : minatoParam,
		dataType:'html',
		scriptCharset: 'utf-8',
		success : function(html){
			var getHtml = $($.parseHTML(html));
			var sessionError = getHtml.filter('#sessionError').val();
			if(sessionError === '0'){
				$('#divMinato').empty();
				$('#divMinato').append(getHtml.filter('#divMinatoRes')[0].innerHTML);
				
				$('.minatoSelect').on(
					'click',
					function(){
						var para1 = $(this).attr('data-para1');
						var para2 = $(this).attr('data-para2');
						var paraN = $(this).attr('data-paraN');
						var paraSetsugangen = $(this).attr('data-paraSetsugangen');
						var paraDouji = $(this).attr('data-paraDouji');
						var type = $(this).attr('data-type');
						minatoSelect(para1,para2,paraN,paraSetsugangen,paraDouji,type);
						/*
						var timeiCd = $(this).attr("data-timeicd");
						$('#searchMinatoCd').val(timeiCd);
						$('#dialogMinato').dialog('close');
						getSearch();
						*/
					}
				);
				$('#dialogMinato').dialog('open');
			}else {
				cm_sessionError();
			}
		}
	});
}

function countKoro(){
	var cntKoro = 0;
	
	$('div.KORO').each(function(){
		if($(this).find('input.koroKbn').val()=='1'){
			cntKoro++;
		}else {
			if($(this).find('input[type="checkbox"]').prop('checked')){
				cntKoro++;
			}
		}
	})
	
	return cntKoro;
}

function getMaxVal(searchData,searchIDX){
	var stacVal = 0;
	for(var i=0; i<searchData.length; i++){
		if(stacVal < searchData[i][searchIDX]){
			stacVal = searchData[i][searchIDX];
		}
	}
	
	return stacVal;
}

function minatoSelect(para1,para2,paraN,paraSetsugangen,paraDouji,type){
	switch(type){
		case "1":
			/*
			location.replace("/Magic33Scripts/MGrqispi.dll?APPNAME=<!$MG_appname>&PRGNAME=W521&ARGUMENTS=-A<!$MG_appname>,-A<!$MG_user>,-A"+para1+",-A"+targetA+",-A"+targetB+",-A"+targetNM+",-A"+targetSetsugangen+",-A"+targetDouji);
			*/
			callMinato2(para1,targetInpCdA,targetInpCdB,targetLblNm,targetFlgSetsugangen,targetFlgDouji);
			break;

		case "2":
			$('#' + targetInpCdA).val(para1);
			$('#' + targetInpCdB).val(para2);
			$('#' + targetLblNm).text(paraN);
			$('#' + targetFlgSetsugangen).val(paraSetsugangen);
			if(targetFlgDouji != '') $('#' + targetFlgDouji).val(paraDouji);			
			searchChangeFLG = true;
			show_hide_FromSetsugange();
			show_hide_ToSetsugange();
			show_hide_ToDouji();
			$('#dialogMinato').dialog('close');
			break;
	}
}

function callMinato2(para1,inpCdA,inpCdB,lblNm,flgSetsugangen,flgDouji){
	var minatoParam = {
		'appname':'NAIS3WEB',
		'prgname':'W521',
		'ssid': $('#ssid').val(),
		'para1' : para1,
		'targetA': inpCdA,
		'targetB': inpCdB,
		'targetC' : lblNm,
		'targetD' : flgSetsugangen,
		'targetE' : flgDouji,
		'arguments':'ssid,para1,targetA,targetB,targetC,targetD,targetE'
	};
	
	$.ajax({
		async : false,
		url: ajaxURL,
		data : minatoParam,
		dataType:'html',
		scriptCharset: 'utf-8',
		success : function(html){
			var getHtml = $($.parseHTML(html));
			var sessionError = getHtml.filter('#sessionError').val();
			if(sessionError === '0'){
				$('#divMinato').empty();
				$('#divMinato').append(getHtml.filter('#divMinatoRes')[0].innerHTML);
				
				$('.minatoSelect').on(
					'click',
					function(){
						var para1 = $(this).attr('data-para1');
						var para2 = $(this).attr('data-para2');
						var paraN = $(this).attr('data-paraN');
						var paraSetsugangen = $(this).attr('data-paraSetsugangen');
						var paraDouji = $(this).attr('data-paraDouji');
						var type = $(this).attr('data-type');
						minatoSelect(para1,para2,paraN,paraSetsugangen,paraDouji,type);
					}
				);
			}else {
				cm_sessionError();
			}
		}
	});
	
}

function NPHelp(){
	var hdnWebDocAlias = $('#hdnWebDocAlias').val();
	window.open(hdnWebDocAlias+"help/nphelp_search001.htm");
}