// JavaScript Document
var docData = [];
var docPastData = [];
var docFavoriteData = [];
var largeSummary = false;
var largeFavorite = false;
var largeContact = false;

var intervalSec = 1000 * 60;
var intervalSearchKbn;
var intervalKyotenKbn;
var intervalDateYM;
var intervalDay;
var intervalOrderNo;
var intervalMinato;
var intervalParam = {
	'appname':'NAIS3WEB',
	'prgname':'W122',
	'ssid': $('#ssid').val(),
	'searchKbn': intervalSearchKbn,
	'kyotenKbn': intervalKyotenKbn,
	'dateYM' : intervalDateYM,
	'day' : intervalDay,
	'orderNo' : intervalOrderNo,
	'minatoCd' : intervalMinato,
	'autoReload' : $('#searchReloadKbn').val(),
	'arguments':'ssid,searchKbn,kyotenKbn,dateYM,day,orderNo,minatoCd,autoReload'
};
var intervalSearchCall;

$(document).ready(function(){
	window.name = "W120";
	
	$('#dialogMinato').dialog({
		autoOpen: false,
		title: "港別水先記録－港選択",
		closeOnEscape: false,
		width: $('body').width() * 0.7,
		modal: true,
		open: function() {
		},
		buttons: {
	        '閉じる': function(){
				$(this).dialog("close");
			}
    	}
	});
	$('#dialogBerth').dialog({
		autoOpen: false,
		title: "",
		closeOnEscape: false,
		width: $('body').width() * 0.78,
		heigth:$('body').height() * 0.6,
		modal: true,
		open: function() {
			setTimeout(function(){
				$('.ui-dialog-buttonset button:eq(0)').focus();
			},0);
		},
		buttons: {
	        '閉じる': function(){
				$(this).dialog("close");
			}
    	}
	});
	$('#dialogSummary').dialog({
		autoOpen: false,
		title: "摘要",
		closeOnEscape: false,
		width: $('body').width() * 0.78,
		height: 300,
		modal: true,
		open: function() {
			setTimeout(function(){
				$('.ui-dialog-buttonset button:eq(1)').focus();
			},0);
		},
		buttons: {
	        '閉じる': function(){
				$(this).dialog("close");
			}
    	}
	});

	
	$('.extract').click(function(){
		var extractKbn = $(this).attr("data-extractKbn");
		$('#searchSyoriKbn').val(extractKbn);
		getSearch();
	});
	
	$('#btnSelectMinato').click(function(){
		minato_noSelect();
	});
	
	if($('#searchReloadKbn').val() === 'Y'){
		setSearchInterval();
	}
	
	$('#btnReload1').click(function(){
		if($('#searchReloadKbn').val() === 'Y'){
			$('#searchReloadKbn').val('N');
			clearInterval(intervalSearchCall);
			$('#spnReloadStatus').text('手動');			
			alert("手動更新に切り替えました。最新ボタンで更新できます。");
		}else {
			$('#searchReloadKbn').val('Y');
			setSearchInterval();
			$('#spnReloadStatus').text('自動');
		}
		getSearch();
	});
	
	$('#btnReload2').click(function(){
		getSearch();
	});
	
	$('#btnGotoKado').click(function(){
		gotoKado();
	});
	
	getSearch();
});

function setSearchInterval(){
	intervalSearchCall = setInterval(function(){
        getSearchCore(intervalParam);
    },intervalSec);
}

function getSearch(){
	var kyotenKbn = $('#slctKyoten').val();
	var minatoCd = '';
	
	if (kyotenKbn === '90') {
		minatoCd = $('#searchMinatoCd').val();
	}else {
		minatoCd = '000';
	}
	if (kyotenKbn === '90' && minatoCd === '000'){
		alert("港を選択してください。");
	}else {
		intervalSearchKbn = $('#searchSyoriKbn').val();
		intervalKyotenKbn = kyotenKbn;
		intervalDateYM = $('#slctDateYM').val();
		intervalDay = $('#slctDay').val();
		intervalOrderNo = $('#searchOrderNo').val();
		intervalMinato = minatoCd;
		
		intervalParam = {
			'appname':'NAIS3WEB',
			'prgname':'W122',
			'ssid': $('#ssid').val(),
			'searchKbn': $('#searchSyoriKbn').val(),
			'kyotenKbn': kyotenKbn,
			'dateYM' : $('#slctDateYM').val(),
			'day' : $('#slctDay').val(),
			'orderNo' : $('#searchOrderNo').val(),
			'minatoCd' : minatoCd,
			'autoReload' : $('#searchReloadKbn').val(),
			'arguments':'ssid,searchKbn,kyotenKbn,dateYM,day,orderNo,minatoCd,autoReload'
		};
		var setParam = {
			'appname':'NAIS3WEB',
			'prgname':'W122',
			'ssid': $('#ssid').val(),
			'searchKbn': $('#searchSyoriKbn').val(),
			'kyotenKbn': kyotenKbn,
			'dateYM' : $('#slctDateYM').val(),
			'day' : $('#slctDay').val(),
			'orderNo' : $('#searchOrderNo').val(),
			'minatoCd' : minatoCd,
			'autoReload' : $('#searchReloadKbn').val(),
			'arguments':'ssid,searchKbn,kyotenKbn,dateYM,day,orderNo,minatoCd,autoReload'
		};
		getSearchCore(setParam);
	}
}

function getSearchCore(searchParam){
	$.ajax({
		async : true,
		url: ajaxURL,
		data : searchParam,
		dataType:'html',
		scriptCharset: 'utf-8',
		success : function(html){			
			var getHtml = $($.parseHTML(html));
			var sessionError = getHtml.filter('#sessionError').val();
			var searchKensu = parseInt(getHtml.filter('#hdnSearchKensu').val());
			if(sessionError === '0'){
				$('#divSearchContents').empty();
				$('#divSearchContents').append(getHtml.filter('#divSearchRes')[0].innerHTML);
				
				var setStr = $('.divSearchHead').children('.left').children('span').text();
				if(setStr !== ""){
					var setArr1 = setStr.split('】');
					var setArr2 = setArr1[1].split('日');
					var setArr3 = setArr2[0].split('月');
					$('#slctDateYM').val(setArr3[0].replace('年','/'));
					$('#slctDay').val(setArr3[1]);
				}
				$('.headYMD').empty();
				$('.headYMD').append(getHtml.filter('#spnheadYMD')[0].innerHTML);
				
				$('#divBerth').empty();
				$('#divBerth').append(getHtml.filter('#dialogBerthRes')[0].innerHTML);
				
				$('#divSummary').empty();
				$('#divSummary').append(getHtml.filter('#dialogSummaryRes')[0].innerHTML);
				
				$('#btnPrintAllTop').on(
					'click',
					function(){
						PKirokuAll();
					}
				);
				$('#btnPrintAllTopBottom').on(
					'click',
					function(){
						PKirokuAll();
					}
				);
				
				$('.btnPrintSelectTop').on(
					'click',
					function(){
						PKirokuSelected();
					}
				);
				$('.btnPrintSelectBottom').on(
					'click',
					function(){
						PKirokuSelected();
					}
				);
				
				$('.printCheck').on(
					'click',
					function(){
						var chbID = $(this).attr("id");
						CntCheck(chbID);
					}
				);
				
				$('.berthLink').click(function(){
					var title = $(this).attr('data-name');
					createBerthLink($(this).attr('data-cdA'),$(this).attr('data-cdB'));

					$('#dialogBerth').dialog('option','title',title);
					$('#dialogBerth').dialog('open');
					$('#dialogBerth').height($('body').width() * 0.2);
					return false;
				});

				$('.summaryLink').click(function(){
					createSummaryLink($(this).attr('data-no'));
					$('#dialogSummary').dialog('open');
					return false;
				});
				
				if(searchKensu !== 0){
					$('.printCheck[data-orderno="'+$('#searchOrderNo').val()+'"]').focus();
				}else {
					cmAlert('エラー','該当のデータはありません。');
				}
			}else {
				cm_sessionError();
			}
		},
		error : function(XMLHttpRequest, textStatus, errorThrown){
				cmAjaxError(XMLHttpRequest, textStatus, errorThrown);
		}
	});
}		

function minato_noSelect(){
	var minatoParam = {
		'appname':'NAIS3WEB',
		'prgname':'W510',
		'ssid': $('#ssid').val(),
		'searchKbn': $('#searchSyoriKbn').val(),
		'kyotenKbn': $('#slctKyoten').val(),
		'dateYM' : $('#slctDateYM').val(),
		'day' : $('#slctDay').val(),
		'orderNo' : $('#searchOrderNo').val(),
		'arguments':'ssid,searchKbn,kyotenKbn,dateYM,day,orderNo'
	};
	
	$.ajax({
		async : false,
		url: ajaxURL,
		data : minatoParam,
		dataType:'html',
		scriptCharset: 'utf-8',
		success : function(html){
			var getHtml = $($.parseHTML(html));
			var sessionError = getHtml.filter('#sessionError').val();
			if(sessionError === '0'){
				$('#divMinato').empty();
				$('#divMinato').append(getHtml.filter('#divMinatoRes')[0].innerHTML);
				
				$('.minatoSelect').on(
					'click',
					function(){
						var timeiCd = $(this).attr("data-timeicd");
						$('#searchMinatoCd').val(timeiCd);
						$('#slctKyoten').val('90');
						$('#dialogMinato').dialog('close');
						getSearch();
					}
				);
				$('#dialogMinato').dialog('open');
			}else {
				cm_sessionError();
			}
		}
	});
}

function createBerthLink(cdA, cdB){
	var docXml = getBerthDoc(cdA,cdB);
	switch( $(docXml).find('ret').text() ){
		case 'I001':
			var lineTag = [];
			lineTag[0] = 'line';
			
			var subLineTag = [];
			subLineTag[0] = 'detailLine';

			createData = xmlToMultiStageArray(docXml,'data',lineTag,subLineTag)
			break;
		case 'S001':
			createData = [];
			break;
		case 'E001':
	        //parent.location.replace("/Magic33Scripts/MGrqispi.dll?APPNAME=<!$MG_appname>&PRGNAME=W040&ARGUMENTS=''");
			$('#prgname').val('W040');
			$('#menuForm').submit();
			break;
	}

	cmSetXML(docXml);

	switch( $('#suiroKbn').val() ){
		case '1':
		case '2':
			$('#tdSuiroData0').hide();
			$('#tdSuiroData1').show();
			$('#tdSuiroData2').show();
			$('#tdSuiroTitle0').hide();
			$('#tdSuiroTitle1').show();
			$('#tdSuiroTitle2').show();
			break;
		default:
			$('#tdSuiroData0').show();
			$('#tdSuiroData1').hide();
			$('#tdSuiroData2').hide();
			$('#tdSuiroTitle0').show();
			$('#tdSuiroTitle1').hide();
			$('#tdSuiroTitle2').hide();
			break;
	}

	$('#divBerthDetail').empty();
	var html = '';
	for( var i = 0; i < createData[0].line.length; i++ ){
		var lineData = createData[0].line[i];
		html = html + '<div class="titlebar">';
		html = html + lineData.kindName;
		html = html + '</div>';
		var dataLineNum = 0;
		var hideFlg = false;
		for( var j = 0; j < lineData.detailLine.length; j++ ){
			var detailData = lineData.detailLine[j];

			if( dataLineNum === 4 ){
				html = html + '<div id="divHideData' + String(i) +'" style="display:none">';
				hideFlg = true;
			}

			if( detailData.title !== '' ){
				html = html + '<div>';
				dataLineNum++;
			}
			html = html + detailData.title + '&nbsp;<a href="#" class="hrefFile" data-kind="' + detailData.docKindCd + '" data-no="' + detailData.docNo + '">' + detailData.link + '</a>';
			if( j < lineData.detailLine.length - 1 ){
				if( lineData.detailLine[j+1].title !== '' ){
					html = html + '</div>';
				}
			}else{
				html = html + '</div>';
			}
		}
		if( hideFlg ){
			html = html + '</div>';
			html = html + '<a href="#" class="arrowData" style="float:right;text-decoration: none;" data-num="' + String(i) + '"><span id="spnArrow' + String(i) +'">続きを見る</span><img src="images/arrowBottom.gif" height="16" width="16" id="imgArrow' + String(i) +'" style="margin-top:2px;border:none;" ></a>';
		}
		html = html + '<br>';
	}

	$('#divBerthDetail').append(html);

	$('.hrefFile').unbind().click(function(){
		var docKind = $(this).attr('data-kind');
		var docNo = $(this).attr('data-no');
		/*
        window.open("/Magic33Scripts/MGrqispi.dll?APPNAME=NAIS3WEB&PRGNAME=D220&ARGUMENTS=-ANAIS3WEB,-A" + $('#ssid').val() + ",-A" + docKind + ",-A" + docNo,
                       "",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=1,menubar=0,left=100,top=60,width=800,height=500,');
		*/
		window.open("","ファイル",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=1,menubar=0,left=100,top=60,width=800,height=500');
		$('#windowForm').attr('target','ファイル');
		$('#Wprgname').val('D220');
		$('#w_param1').val('ANAIS3WEB');
		$('#w_param2').val($('#ssid').val());
		$('#w_param3').val(docKind);
		$('#w_param4').val(docNo);
		$('#w_param5').val('');
		$('#w_param6').val('');
		$('#w_param7').val('');
		$('#w_param8').val('');
		$('#w_param9').val('');
		$('#w_param10').val('');
		$('#windowForm').submit();
		$('#windowForm').attr('target','_self');
		return false;
	});

	$('.arrowData').unbind().click(function(){
		var dataNum = $(this).attr("data-num");
		slideData(dataNum);
		return false;
	});
}

function slideData(dataNum){
	if($('#divHideData'+ dataNum ).css("display") === "none"){
		$('#spnArrow' + dataNum).text('隠す');
		$('#imgArrow' + dataNum).attr('src','images/arrowRight.gif');
		$('#divHideData'+ dataNum ).slideDown();
	} else {
		$('#spnArrow' + dataNum).text('続きを見る');
		$('#imgArrow' + dataNum).attr('src','images/arrowBottom.gif');
		$('#divHideData'+ dataNum ).slideUp();
	}
}

function getBerthDoc(cdA,cdB){
	var param = {
		'appname':'NAIS3WEB',
		'prgname':'D230',
		'ssid': $('#ssid').val(),
		'cdA': cdA,
		'cdB': cdB,
		'arguments':'ssid,cdA,cdB'
	};

	var xmlData = cmGetXmlData(param,'0');
	return xmlData;
}

function createSummaryLink(orderNo){
	var docXml = getSummaryData(orderNo);
	switch( $(docXml).find('ret').text() ){
		case 'I001':
			cmSetXML(docXml);
			break;
		case 'E001':
	        //parent.location.replace("/Magic33Scripts/MGrqispi.dll?APPNAME=<!$MG_appname>&PRGNAME=W040&ARGUMENTS=''");
			$('#prgname').val('W040');
			$('#menuForm').submit();
			break;
	}
}

function getSummaryData(orderNo){
	var param = {
		'appname':'NAIS3WEB',
		'prgname':'D240',
		'ssid': $('#ssid').val(),
		'orderNo': orderNo,
		'arguments':'ssid,orderNo'
	};

	var xmlData = cmGetXmlData(param,'0');
	return xmlData;
}

//稼動記録に戻る
function gotoKado(){
	var kadoFunk = $('#hdnKadoFunk').val();
	var kadoSubMenu = 0;
	var kadoHaijo = $('#hdnKadoHaijo').val();
	var kadoRigyo = $('#hdnKadoRigyo').val();
	var kadoShikaku = $('#hdnKadoShikaku').val();
	$('#prgname').val('W110');
	$('#param1').val(kadoFunk);
	$('#param2').val(kadoSubMenu);
	$('#param3').val(kadoHaijo);
	$('#param4').val(kadoRigyo);
	$('#param5').val(kadoShikaku);
	$('#menuForm').submit();
	/*
parent.location.replace("/Magic33Scripts/MGrqispi.dll?APPNAME=<!$MG_appname>&PRGNAME=W110&ARGUMENTS=-A<!$MG_appname>,-A<!$MG_user>,-A0,-A"
+ "<!$MG_kado_funk1>,-A<!$MG_kado_haijo>,-A<!$MG_kado_rigyo>,-A<!$MG_kado_shikaku>");
*/
}

//支援情報
function SienJoho(order_no){
	var funk1     = $('#searchSyoriKbn').val();
	var kyoten    = $('#slctKyoten').val();	
	var r_dateym  = $('#slctDateYM').val();
	var r_dated   = $('#slctDay').val();
	var kadoFunk = $('#hdnKadoFunk').val();
	var kadoHaijo = $('#hdnKadoHaijo').val();
	var kadoRigyo = $('#hdnKadoRigyo').val();
	var kadoShikaku = $('#hdnKadoShikaku').val();
	var minato    = $('#searchMinatoCd').val();
	$('#prgname').val('W130');
	$('#param1').val(funk1);
	$('#param2').val(kyoten);
	$('#param3').val(r_dateym);
	$('#param4').val(r_dated);
	$('#param5').val(order_no);	
	$('#param6').val('W120');
	$('#param7').val('W110');
	$('#param8').val(kadoFunk);
	$('#param9').val(kadoHaijo);
	$('#param10').val(kadoRigyo);
	$('#param11').val(kadoShikaku);
	$('#param12').val(minato);
	$('#menuForm').submit();
	/*
	parent.location.replace("/Magic33Scripts/MGrqispi.dll?APPNAME=<!$MG_appname>&PRGNAME=W130&ARGUMENTS=-A<!$MG_appname>,-A<!$MG_user>,-A"
	+ funk1 + ",-A" + kyoten + ",-A" + r_dateym + ",-A" + r_dated + ",-A" + order_no + ",-AW120,-A"
	+ "<!$MG_kado_pgm_id>,-A<!$MG_kado_funk1>,-A<!$MG_kado_haijo>,-A<!$MG_kado_rigyo>,-A<!$MG_kado_shikaku>,-A<!$MG_minato_cd>");
	*/
}
//水先記録印刷
function PKirokuPrt(order_no){
	var funk1     = $('#searchSyoriKbn').val();
	var kyoten    = $('#slctKyoten').val();
	var minato    = $('#searchMinatoCd').val();
	var r_dateym  = $('#slctDateYM').val();
	var r_dated   = $('#slctDay').val();
	var ssid = $('#ssid').val();
	/*
	var printUrl = naisserver+'?APPNAME='+nasiappname+'&PRGNAME=W140&ARGUMENTS=-A'+nasiappname+',-A'+ssid+',-A'+funk1+',-A'+kyoten+',-A'+r_dateym+',-A'+r_dated+',-A'+minato+',-A'+order_no;
	window.open(printUrl,"水先記録印刷",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=0,menubar=0,left=100,top=60,width=800,height=550,');
	*/
	window.open("","水先記録印刷",'toolbar=0,directories=0,status=1,resizable=1,scrollbars=0,menubar=0,left=100,top=60,width=800,height=550');
	$('#windowForm').attr('target','水先記録印刷');
	$('#Wprgname').val('W140');
	$('#w_param1').val(nasiappname);
	$('#w_param2').val(ssid);
	$('#w_param3').val(funk1);
	$('#w_param4').val(kyoten);
	$('#w_param5').val(r_dateym);
	$('#w_param6').val(r_dated);
	$('#w_param7').val(minato);
	$('#w_param8').val(order_no);
	$('#w_param9').val('');
	$('#w_param10').val('');
	$('#windowForm').submit();
	$('#windowForm').attr('target','_self');
}
//水先記録印刷(選択)
function PKirokuSelected(){
	var order_no  = "";
	$('.printCheck').each(function(){
		if($(this).prop('checked')){
			order_no = order_no + $(this).attr("data-orderNo");
		}
	});
	if( order_no === "" ){
		alert("オーダーをチェックしてください");
	}else {
		PKirokuPrt(order_no);
	}
}
//水先記録印刷(全頁)
function PKirokuAll(){
	var order_no = "";
	PKirokuPrt(order_no);
}

//チェックボックスのチェック数
function CntCheck(chbID){
	var chbCnt = 0;
	var maxCnt = $('#hdnCheckCntMax').val();
	$('.printCheck').each(function(){
		if($(this).prop('checked')){
			chbCnt = chbCnt + 1;
		}
	});
	
	if (chbCnt > maxCnt){
		alert(maxCnt.toString()+"個以上はチェックできません");
		$('#'+chbID).prop('checked',false);
	}
}

function NPHelp(){
	var hdnWebDocAlias = $('#hdnWebDocAlias').val();
	window.open(hdnWebDocAlias+"help/nphelp_mizusaki001.htm");
}