// JavaScript Document
var web_doc_alias = '';
var calcHarvorFrom = '',calcHarvorFrom2 = '';
var calcHarvorTo = '',calcHarvorTo2 = '';
var newCalcFlg = true;
$(document).ready(function(){
	setupZoomModal('harbor');
	setupZoomModal('shipName');
	web_doc_alias = $('#web_doc_alias').val();
	ptnSet();
	showTable();

	//ズームのコールバック関数を設定
	//zoomCallBackFncはzoom_agency.js内で宣言
	zoomCallBackFnc['callBackHarvor'] = callBackHarvor;
	
	$('#mdlMinatoList').on('show.bs.modal', function (e) {
		var minatoParam = {
			'appname':'NAIS3WEB',
			'prgname':'W510',
			'ssid': $('#ssid').val(),
			'searchKbn': '',
			'kyotenKbn': '',
			'dateYM' : '',
			'day' : '',
			'orderNo' : '',
			'arguments':'ssid,searchKbn,kyotenKbn,dateYM,day,orderNo'
		};
		var retHtml = ajaxFunctionHtml(minatoParam);
		var getHtml = $($.parseHTML(retHtml));
		var sessionError = getHtml.filter('#sessionError').val();
		if(sessionError === '0'){
			$('#mdlMinatoListContenrs').empty();
			$('#mdlMinatoListContenrs').append(getHtml.filter('#divMinatoRes')[0].innerHTML);
			$('.minatoSelect').each(function(){
				$(this).attr('data-bs-dismiss','modal');
				$(this).attr('aria-label','Close');
			});
			$('.minatoSelect').on('click',function(){
				var timeiCd = $(this).attr("data-timeicd");
				$('#searchMinatoCd').val(timeiCd);
				$('#spnMinatoName').text($(this).text());
				$('#slctKyoten').val('90');
			});
		}
		
	});
	
	$('#btnSearch').on('click',function(){
		if($('#searchPortKbn').val() == '0' && $('#searchMinatoCd').val() == ''){
			modalAlert('0','エラー！','当直港を選択してください。');
		}else if($('#searchPortKbn').val() == '1' && $('#hdnSelectMinato').val() == ''){
			modalAlert('0','エラー！','港を選択してください。');
		}else if($('#searchPortKbn').val() == '2' && $('#hdnHarvorCdTo').val() == ''){
			modalAlert('0','エラー！','地名を選択してください。');
		}else{
			searchList();
		}
	});
	
	$('#btnBack').on('click',function(){
		$('#prgname').val('A020');
		$('#param1').val('0');
		$('#menuForm').submit();
	});

	$('#btnSelectMinato').click(function(){
		minato_noSelect();
	});

	$('#dialogMinato').dialog({
		autoOpen: false,
		title: "港別水先記録－港選択",
		closeOnEscape: false,
		width: $('body').width() * 0.7,
		modal: true,
		open: function() {
		},
		buttons: {
	        '閉じる': function(){
				$(this).dialog("close");
			}
    	}
	});

	$('#searchPortKbn').on('change',function(){
		ptnSet();
	});

	$(document).on( 'click', '#table1 a', function () {
        var btn_name = $(this).attr('btn-name');
        var target_no = $(this).attr('target-no');
		if (btn_name){
			if (btn_name == "shipname") {
				SienJoho(target_no);
			} 
		}
    } );
});

function ptnSet(){
	if($('#searchPortKbn').val() == '0'){
		$('.ptn1').show();
		$('.ptn2').hide();
		$('.ptn3').hide();
	}else if($('#searchPortKbn').val() == '1'){
		$('.ptn1').hide();
		$('.ptn2').show();
		$('.ptn3').hide();
	}else{
		$('.ptn1').hide();
		$('.ptn2').hide();
		$('.ptn3').show();
	}
}

function showTable(){
	// datatableの設定を変更
	varTable1 =	$("#table1").DataTable({
		dom:"<'row'<'col-sm-6'i><'col-sm-6 right mb-1'f>>" +
		"<'row'<'col-sm-12'tr>>" +
		"<'row'<'col-sm-6 mt-1'l><'col-sm-6 right mt-1'p>>",
		'paging'      :true,
		'pageLength'  :10,
		'lengthChange':true,
		'searching'   :true,
		'ordering'    :true,
		'info'        :true,
		'autoWidth'   :false,
		'scrollX'     :true,
		'scrollY'     :true,
		'order'       :[],
		'columns'     :[
		{data:"date",width:"100px",className:"dt-body-center dt-nowrap"},
		{data:"time",width:"100px",className:"dt-nowrap"},
		{data:"name",className:"dt-nowrap"},
		{data:"loa",width:"50px",className:"dt-body-right dt-nowrap"},
		{data:"weight",width:"50px",className:"dt-body-right dt-nowrap"},
		{data:"speed",width:"90px",className:"dt-body-right dt-nowrap"},
		{data:"seki",width:"150px",className:"dt-nowrap"},
		{data:"from",width:"150px",className:"dt-nowrap"},
		{data:"to",width:"150px",className:"dt-nowrap"}
		],
		"language": {
			"url": "../webnais/lib/DataTables/plug-ins/Japanese.json"
		}
	});
};

function searchList(){
	var chkSea = '';
	var chkHabor = '';
	var chkUserShitei = '';
	if($('#chkSea').prop('checked')){ chkSea = '1'; }
	if($('#chkHabor').prop('checked')){ chkHabor = '1'; }
	if($('#chkUserShitei').prop('checked')){ chkUserShitei = '1'; }

	var param = {
		'appname': nasiappname,
		'prgname':'W401',
		'param1': $('#ssid').val(),
		'param2': '90',
		'param3': $('#searchPortKbn').val(),
		'param4': $('#searchMinatoCd').val(),
		'param5': $('#hdnSelectMinato').val(),
		'param6': $('#hdnHarvorCdTo').val(),
		'param7': $('#hdnHarvorCdTo2').val(),
		'param8': $('#inpJousenDateFrom').val(),
		'param9': $('#inpJousenDateTo').val(),
		'param10': chkSea,
		'param11': chkHabor,
		'param12': chkUserShitei,
		'arguments':'param1,param2,param3,param4,param5,param6,param7,param8,param9,param10,param11,param12'
	};
	var retXml = ajaxFunction(param);
	var kekka = $(retXml).find('ret').text();
	var kensu = $(retXml).find('kensu').text();
	if(kekka === 'I001'){
		varTable1.state.clear();
		varTable1.destroy();
		$("#table1 tbody > tr").remove();
		showTable();
		$(retXml).find('lines').each(function(){
			var ship_name = $(this).find('ship_name').text();
			var operator1 = $(this).find('operator1').text();
			var agency1 = $(this).find('agency1').text();
			var loa = $(this).find('loa').text();
			var big = $(this).find('big').text();
			var kiken = $(this).find('kiken').text();
			var dw = $(this).find('dw').text();
			var gt = $(this).find('gt').text();
			var soku = $(this).find('soku').text();
			var df = $(this).find('df').text();
			var senseki = $(this).find('senseki').text();
			var josenchi_name = $(this).find('josenchi_name').text();
			var josen_memo = $(this).find('josen_memo').text();
			var kyodo_date = $(this).find('kyodo_date').text();
			var kyodo_kbn = $(this).find('kyodo_kbn').text();
			var sousen_time = $(this).find('sousen_time').text();
			var kanri = $(this).find('kanri').text();
			var gesenchi_name = $(this).find('gesenchi_name').text();
			var gesen_memo = $(this).find('gesen_memo').text();
			var order_no = $(this).find('order_no').text();
			varTable1.row.add({
				name:'<a href="#" btn-name="shipname" target-no="' + order_no +'">' + ship_name + '</a> <br>' + operator1 + agency1
				,loa:loa + '<br><span>' + big + '</span><span class="text-danger">　' + kiken + '</span>'
				,weight:dw + '<br>' + gt
				,speed:soku + '<br>' + df
				,from:'<span style="font-weight:bold;">' + josenchi_name + '</span>'
				,date:'<span style="font-weight:bold;">' + kyodo_date + '</span> <br>' + kyodo_kbn
				,time:'<span style="font-weight:bold;">' + sousen_time + '</span>'
				,to:'<span style="font-weight:bold;">' + gesenchi_name + '</span>'
				,seki:senseki
				}).draw(false);
		});
		if(kensu == 0){
			cmAlert('エラー','該当のデータはありません。');
		}
	}
}

function minato_noSelect(){
	var minatoParam = {
		'appname':'NAIS3WEB',
		'prgname':'W510',
		'ssid': $('#ssid').val(),
		'searchKbn': '0',
		'kyotenKbn': '90',
		'dateYM' : '0',
		'day' : '0',
		'orderNo' : '',
		'arguments':'ssid,searchKbn,kyotenKbn,dateYM,day,orderNo'
	};
	
	$.ajax({
		async : false,
		url: ajaxURL,
		data : minatoParam,
		dataType:'html',
		scriptCharset: 'utf-8',
		success : function(html){
			var getHtml = $($.parseHTML(html));
			var sessionError = getHtml.filter('#sessionError').val();
			if(sessionError === '0'){
				$('#divMinato').empty();
				$('#divMinato').append(getHtml.filter('#divMinatoRes')[0].innerHTML);
				
				$('.minatoSelect').on(
					'click',
					function(){
						var timeiCd = $(this).attr("data-timeicd");
						var timeiNm = $(this).attr("data-timeinm");
						$('#hdnSelectMinato').val(timeiCd);
						$('#slctKyoten').val('90');
						$('#txtSelectMinatoNm').text(timeiNm);
						$('#dialogMinato').dialog('close');
						//getSearch();
					}
				);
				$('#dialogMinato').dialog('open');
			}else {
				cm_sessionError();
			}
		}
	});
}

function callBackHarvor(){
	var newHarvorFrom = $('#hdnHarvorCdFrom').val();
	var newHarvorFrom2 = $('#hdnHarvorCdFrom2').val();
	var newHarvorTo = $('#hdnHarvorCdTo').val();
	var newHarvorTo2 = $('#hdnHarvorCdTo2').val();
	if(calcHarvorFrom !== newHarvorFrom || calcHarvorFrom2 !== newHarvorFrom2 || calcHarvorTo !== newHarvorTo || calcHarvorTo2 !== newHarvorTo2){
		newCalcFlg = true;
		$('#btnKoro').prop('disabled',true);
	}
	if (newHarvorTo==='330' && (newHarvorTo2==='00' || newHarvorTo2==='01' || newHarvorTo2==='02' || newHarvorTo2==='03')){
		$('.hiro').removeClass('d-none');
	} else {
		$('.hiro').addClass('d-none');
	}
}

//支援情報
function SienJoho(order_no){
	$('#prgname').val('W130');
	$('#param1').val('');
	$('#param2').val('');
	$('#param3').val('');
	$('#param4').val('');
	$('#param5').val(order_no);	
	$('#param6').val('W400');
	$('#param7').val('');
	$('#param8').val('');
	$('#param9').val('');
	$('#param10').val('');
	$('#param11').val('');
	$('#param12').val('10');

//	window.open('about:blank','sienJoho','toolbar=0,directories=0,status=1,resizable=1,scrollbars=1,menubar=0,');
	$('#menuForm').attr('target','sienJoho')
	$('#menuForm').submit();
	$('#menuForm').attr('target','_self')
}