
// JavaScript Document
var web_doc_alias = '';
var validPtn = '';
$(document).ready(function(){
	setupZoomModal('shipName');
	web_doc_alias = $('#web_doc_alias').val();

	//初期値セット
	setFirstDisp();

	//文字数チェック
	$.validator.addMethod(
        'mojichk',
        function(value,element,num){
            count = textbyte(value);
            if (this.optional(element)){
                return true;
            } else if (count > num){
                return false;
            } else {
                return true;
            }
        },       
    );
	//許可文字チェック
    $.validator.addMethod(
        'kyokamoji',
        function(value,element){
            if (this.optional(element)){
                return true;
            } else if (value.match(/[^(0-9A-Z)]+/)){
                return false;
            } else {
                return true;
            }
        },'英大文字か半角数値のみ入力して下さい。'  
    );
	//電話番号チェック
    $.validator.addMethod(
        'telcheck',
        function(value,element){
            if (this.optional(element)){
                return true;
            } else if (value.match(/[^0-9-]+/)){
                return false;
            } else {
                return true;
            }
        },'半角数値と - のみ入力して下さい。'  
    );
	//禁止文字チェック(& , % # + \)
    $.validator.addMethod(
        'kinshi',
        function(value,element){
            if (this.optional(element)){
                return true;
            } else if (value.match(/&/i) == "&"){
                return false;
            } else if (value.match(/,/i) == ","){
                return false;
            } else if (value.match(/%/i) == "%"){
                return false;
            } else if (value.match(/#/i) == "#"){
                return false;
            } else if (value.match(/\+/i) == "\+"){
                return false;
            } else if (value.match(/\\/i) == "\\"){
                return false;
            } else if (value.match(/</i) == "<"){
                return false;
            } else if (value.match(/>/i) == ">"){
                return false;
            } else {
                return true;
            }
        },'入力できない文字が含まれています。'  
    );
	//小数部桁数チェック
    $.validator.addMethod(
        'decimalcheck',
        function(value,element,num){
			array = value.split('.');
            if (this.optional(element)){
                return true;
            } else if (array.length > 1 && array[1].length > num){
                return false;
            } else {
                return true;
            }
        },  
    );

	$('#form_A112').validate({
		ignore: [], //type="hidden"項目のエラーチェックを可能とする
		rules : {
			inpImoNo : {
				digits: true
			},
			inpCallSigne : {
				required: function(){return validPtn == '1';} ,
				kyokamoji: true
			},
			inpShipName : {
				required: function(){return validPtn == '1';} ,
				mojichk: 30,
				kinshi: true
			},
			inpO_sensyu : {
				mojichk: 30,
				kinshi: true
			},
			inpO_senseki : {
				mojichk: 30,
				kinshi: true
			},
			inpHonsen_mail : {
				email: true 
			},
			inpInmaru_tel : {
				telcheck: true 
			},
			inpInmaru_fax : {
				telcheck: true 
			},
			inpSenpaku_tel : {
				telcheck: true 
			},
			inpSo_ton : {
				required: function(){return validPtn == '1';} ,
				digits: true,
				min : function(){if(validPtn == '1'){return 1}else{return 0};}
			},
			inpSin_ton : {
				digits: true,
				min : function(){if(validPtn == '1'){return 1}else{return 0};}
			},
			inpJuryo_ton : {
				required: function(){return validPtn == '1';} ,
				digits: true,
				min : function(){if(validPtn == '1'){return 1}else{return 0};}
			},
			inpJuryo_genton : {
				digits: true,
				min : function(){if(validPtn == '1'){return 1}else{return 0};}
			},
			inpZencho : {
				required: function(){return validPtn == '1';} ,
				min: function(){if(validPtn == '1'){return 0.01}else{return 0};},
				max: 999.99,
				decimalcheck: 2
			},
			inpSensyu_senkyo : {
				required: function(){return validPtn == '1';} ,
				min: function(){if(validPtn == '1'){return 0.01}else{return 0};},
				max: 999.99,
				decimalcheck: 2
			},
			inpSentei : {
				required: function(){return validPtn == '1';} ,
				min: function(){if(validPtn == '1'){return 0.01}else{return 0};},
				max: 999.99,
				decimalcheck: 2
			},
			inpKeifuku : {
				max: 999.99,
				decimalcheck: 2
			},
			inpKeisin : {
				max: 999.99,
				decimalcheck: 2
			},
			inpKissui : {
				max: 99.999,
				decimalcheck: 3
			},
			inpMan_soku : {
				required: function(){return validPtn == '1';} ,
				min: function(){if(validPtn == '1'){return 0.1}else{return 0};}
			},
			inpBow : {
				digits: true
			},
			inpStern : {
				digits: true
			},
			inpO_pi_hoken : {
				mojichk: 40,
				kinshi: true
			},
			inpKanpan : {
				digits: true
			},
			inpO_nation_cap : {
				mojichk: 20,
				kinshi: true
			},
			inpNation_crew : {
				mojichk: 60,
				kinshi: true
			},
			/*
			chbRadar : {
				required: function(){return validPtn == '1';} 
			},
			chbArpa : {
				required: function(){return validPtn == '1';} 
			},
			chbGyro : {
				required: function(){return validPtn == '1';} 
			},
			chbAis : {
				required: function(){return validPtn == '1';} 
			},
			chbSyuki : {
				required: function(){return validPtn == '1';} 
			},
			chbHatsuden : {
				required: function(){return validPtn == '1';} 
			},
			chbKajitori : {
				required: function(){return validPtn == '1';} 
			},
			chbKiteki : {
				required: function(){return validPtn == '1';} 
			},
			chbBlackcyl : {
				required: function(){return validPtn == '1';} 
			},
			chbGreenlight : {
				required: function(){return validPtn == '1';} 
			},
			chbRedlight : {
				required: function(){return validPtn == '1';} 
			},
			chbBlackout : {
				required: function(){return validPtn == '1';} 
			},
			chbHijyosoda : {
				required: function(){return validPtn == '1';} 
			},
			*/
			inpSonota_k : {
				mojichk: 20,
				kinshi: true
			},
			txtTokki : {
				mojichk: 200,
				kinshi: true
			},
		},
		messages: {
			inpImoNo : {
				digits: '半角数値のみ入力して下さい。'
			},
			inpCallSigne : {
				required: 'コールサインを入力して下さい。',
			},
			inpShipName : {
				required: '船名を入力して下さい。',
				mojichk: '文字数オーバー(全角15文字,半角30文字)'
			},
			inpO_sensyu : {
                mojichk: '文字数オーバー(全角15文字,半角30文字)'
			},
			inpO_senseki : {
				mojichk: '文字数オーバー(全角15文字,半角30文字)。'
			},
			inpHonsen_mail : {
				email : 'メールアドレスを入力して下さい。'
			},
			inpSo_ton : {
				required: '総トン数を入力して下さい。',
				digits: '整数を入力して下さい。',
				min : '整数を入力して下さい。'
			},
			inpSin_ton : {
				digits: '整数を入力して下さい。',
				min : '整数を入力して下さい。'
			},
			inpJuryo_ton : {
				required: '総トン数を入力して下さい。',
				digits: '整数を入力して下さい。',
				min : '整数を入力して下さい。'
			},
			inpJuryo_genton : {
				digits: '整数を入力して下さい。',
				min : '整数を入力して下さい。'
			},
			inpZencho : {
				required: '全長を入力して下さい。',
				min: '全長を入力して下さい。',
				max: 'LOA:桁数エラー',
				decimalcheck: 'LOA:桁数エラー（小数部２桁まで）'
			},
			inpSensyu_senkyo : {
				required: '船首-船橋を入力して下さい。',
				min: '船首-船橋を入力して下さい。',
				max: '船首-船橋間:桁数エラー',
				decimalcheck: '船首-船橋間:桁数エラー（小数部２桁まで）'
			},
			inpSentei : {
				required: '船底-最高部を入力して下さい。',
				min: '船底-最高部を入力して下さい。',
				max: '船底-最高部:桁数エラー',
				decimalcheck: '船底-最高部:桁数エラー（小数部２桁まで）'
			},
			inpKeifuku : {
				max: '型幅:桁数エラー',
				decimalcheck: '型幅:桁数エラー（小数部２桁まで）'
			},
			inpKeisin : {
				max: '型深:桁数エラー',
				decimalcheck: '型深:桁数エラー（小数部２桁まで）'
			},
			inpKissui : {
				max: '満載時喫水:桁数エラー',
				decimalcheck: '満載時喫水:桁数エラー（小数部３桁まで）'
			},
			inpMan_soku : {
				required: '航海速力を入力して下さい。',
				min: '航海速力を入力して下さい。',
				max: '上限を超えています。',
				step: '航海速力:桁数エラー（小数部１桁まで）'
			},
			inpKou_soku_f : {
				max: '上限を超えています。'
			},
			inpKou_soku_h : {
				max: '上限を超えています。'
			},
			inpKou_soku_s : {
				max: '上限を超えています。'
			},
			inpKou_soku_ds : {
				max: '上限を超えています。'
			},
			inpO_pi_hoken : {
				mojichk: '文字数オーバー(全角20文字,半角40文字)。'
			},
			inpKanpan : {
				digits: '整数を入力して下さい。'
			},
			inpO_nation_cap : {
				mojichk: '文字数オーバー(全角30文字,半角60文字)。'
			},
			inpNation_crew : {
				mojichk: '文字数オーバー(全角10文字,半角20文字)。'
			},
			/*
			chbRadar : {
				required: '未確認'
			},
			chbArpa : {
				required: '未確認'
			},
			chbGyro : {
				required: '未確認'
			},
			chbAis : {
				required: '未確認'
			},
			chbSyuki : {
				required: '未確認'
			},
			chbHatsuden : {
				required: '未確認'
			},
			chbKajitori : {
				required: '未確認'
			},
			chbKiteki : {
				required: '未確認'
			},
			chbBlackcyl : {
				required: '未確認'
			},
			chbGreenlight : {
				required: '未確認'
			},
			chbRedlight : {
				required: '未確認'
			},
			chbBlackout : {
				required: '未確認'
			},
			chbHijyosoda : {
				required: '未確認'
			},
			*/
			inpSonota_k : {
				mojichk: '文字数オーバー(全角10文字,半角20文字)。'
			},
			txtTokki : {
                mojichk: '文字数オーバー(全角100文字,半角200文字)'
			},
		},
		errorClass: "formValidError",
		errorPlacement: function(error, element) {
			var parentObj = $(element).parent();
			parentObj.append(error);
			if(!$(error).hasClass('p-1')){ $(error).addClass('p-1'); }
		},
	});

	//船種切替
	$('#slctSensyu').on('change',function(){
		if($(this).val() == '98'){
			$('#inpO_sensyu').prop('disabled',false);
		}else{
			$('#inpO_sensyu').val('');
			$('#inpO_sensyu').prop('disabled',true);
		}
		changeSlctSensyu();
	});

	//船籍切替
	$('#slctSenseki').on('change',function(){
		if($(this).val() == '***'){
			$('#inpO_senseki').prop('disabled',false);
		}else{
			$('#inpO_senseki').val('');
			$('#inpO_senseki').prop('disabled',true);
		}
		changeSlctSenseki();
	});

	$('#inpO_senseki').on('change',function(){
		changeSlctSenseki();
	})

	//新トン数入力切替
	$('#chbSin_ton').on('change',function(){
		if($(this).prop('checked')){
			$('#inpSin_ton').prop('disabled',false);
		}else {
			$('#inpSin_ton').val('');
			$('#inpSin_ton').prop('disabled',true);
		}
		changeInpSin_ton();
	});

	$('#inpSin_ton').on('change',function(){
		changeInpSin_ton();
	})

	//重量減トン船入力切替
	$('#chbJuryo_genton').on('change',function(){
		if($(this).prop('checked')){
			$('#inpJuryo_genton').prop('disabled',false);
		}else {
			$('#inpJuryo_genton').val('');
			$('#inpJuryo_genton').prop('disabled',true);
		}
		changeInpJuryo_genton();
	});

	$('#inpJuryo_genton').on('change',function(){
		changeInpJuryo_genton();
	})	

	//スラスター入力切替
	$('#chbThr').on('change',function(){
		if($(this).prop('checked')){
			$('#inpBow').prop('disabled',false);
			$('#inpStern').prop('disabled',false);
		}else {
			$('#inpBow').val('');
			$('#inpStern').val('');
			$('#inpBow').prop('disabled',true);
			$('#inpStern').prop('disabled',true);
		}
		changeChbThr();
	});

	$('#inpBow').on('change',function(){
		changeChbThr();
	})

	$('#inpStern').on('change',function(){
		changeChbThr();
	})

	//PI保険切替
	$('#slctPi_hoken').on('change',function(){
		if($(this).val() == '999'){
			$('#inpO_pi_hoken').prop('disabled',false);
		}else{
			$('#inpO_pi_hoken').val('');
			$('#inpO_pi_hoken').prop('disabled',true);
		}
		changeSlctPi_hoken();
	});

	//船長切替
	$('#slctNation_cap').on('change',function(){
		if($(this).val() == '***'){
			$('#inpO_nation_cap').prop('disabled',false);
		}else{
			$('#inpO_nation_cap').val('');
			$('#inpO_nation_cap').prop('disabled',true);
		}
		changeSlctNation_cap();
	});

	//戻る
	$('#btnCancel').on('click',function(){
		modalAlert('1','確認','入力が取り消されますが、よろしいですか？',callbackCancel);
	});

	//一時保存
	$('#btnSave').on('click',function(){
		validPtn = '0';
			if($('#form_A112').valid()){
				updateMizusakiIrai('1');
			}else {
				modalAlert('0','エラー！','入力内容を確認してください。');
			}
	});

	//嚮導情報入力へ進む
	$('#btnNext').on('click',function(){
		validPtn = '1';
		var errCount = 0;

		errCount = errCount + changeSlctSensyu();
		errCount = errCount + changeSlctSenseki();
		errCount = errCount + changeInpSin_ton();
		errCount = errCount + changeInpJuryo_genton();
		errCount = errCount + changeChbThr();
		errCount = errCount + changeSlctPi_hoken();
		errCount = errCount + changeSlctNation_cap();
		
		if($('#form_A112').valid()){
			if(errCount == 0) {
				$('#lblErrSensyu').text('');
				$('#lblErrSenseki').text('');
				$('#lblErrSinton').text('');
				$('#lblErrJuryogenton').text('');
				$('#lblErrThr').text('');
				$('#lblErrPihoken').text('');
				$('#lblErrNationcap').text('');
				updateMizusakiIrai('2');
			} else {
				modalAlert('0','エラー！','入力内容を確認してください。');
				return false;
			}
		}else {
			modalAlert('0','エラー！','入力内容を確認してください。');
		}
	});

	//請求情報入力へ戻る
	$('#btnBack').on('click',function(){
		validPtn = '0';
			if($('#form_A112').valid()){
				updateMizusakiIrai('3');
			}else {
				modalAlert('0','エラー！','入力内容を確認してください。');
			}
	});

	//IMO-No.からシップマスタ取得
	$('#inpImoNo').on('change',function(){
		validPtn = '0';
			if($('#form_A112').valid()){
				updateMizusakiIrai('4');
			}else {
				modalAlert('0','エラー！','入力内容を確認してください。');
			}
	});

	// ズームのコールバック関数を設定
	// zoomCallBackFncはzoom_agency.js内で宣言
	zoomCallBackFnc['callBackShipName'] = callBackShipName;

	//指名船制度申請
	$('#btnApply').on('click',function(){
		shimeiApply();
	})

});

//船名検索の戻りからシップマスタ取得
function callBackShipName(){
	validPtn = '0';
	if($('#form_A112').valid()){
		updateMizusakiIrai('4');
	}else {
		modalAlert('0','エラー！','入力内容を確認してください。');
	}
}

//初期値セット
function setFirstDisp(){
	//チェックボックス
	if($('#hdnSin_ton_check').val() == '1'){
		$('#chbSin_ton').prop('checked',true);
	}
	if($('#hdnJuryo_genton_check').val() == '1'){
		$('#chbJuryo_genton').prop('checked',true);
	}
	if($('#hdnThr_check').val() == '1'){
		$('#chbThr').prop('checked',true);
	}
	if($('#hdnRadar_check').val() == '0'){
		$('#chbRadar').prop('checked',true);
	}
	if($('#hdnArpa_check').val() == '0'){
		$('#chbArpa').prop('checked',true);
	}
	if($('#hdnGyro_check').val() == '0'){
		$('#chbGyro').prop('checked',true);
	}
	if($('#hdnAis_check').val() == '0'){
		$('#chbAis').prop('checked',true);
	}
	if($('#hdnSyuki_check').val() == '0'){
		$('#chbSyuki').prop('checked',true);
	}
	if($('#hdnHatsuden_check').val() == '0'){
		$('#chbHatsuden').prop('checked',true);
	}
	if($('#hdnKajitori_check').val() == '0'){
		$('#chbKajitori').prop('checked',true);
	}
	if($('#hdnKiteki_check').val() == '0'){
		$('#chbKiteki').prop('checked',true);
	}
	if($('#hdnBlackcyl_check').val() == '0'){
		$('#chbBlackcyl').prop('checked',true);
	}
	if($('#hdnGreenlight_check').val() == '0'){
		$('#chbGreenlight').prop('checked',true);
	}
	if($('#hdnRedlight_check').val() == '0'){
		$('#chbRedlight').prop('checked',true);
	}
	if($('#hdnBlackout_check').val() == '0'){
		$('#chbBlackout').prop('checked',true);
	}
	if($('#hdnHijyosoda_check').val() == '0'){
		$('#chbHijyosoda').prop('checked',true);
	}
	//船種
	if($('#slctSensyu').val() == '98'){
		$('#inpO_sensyu').prop('disabled',false);
	}else{
		$('#inpO_sensyu').val('');
		$('#inpO_sensyu').prop('disabled',true);
	}
	//船籍
	if($('#slctSenseki').val() == '***'){
		$('#inpO_senseki').prop('disabled',false);
	}else{
		$('#inpO_senseki').val('');
		$('#inpO_senseki').prop('disabled',true);
	}
	//新トン数
	if($('#chbSin_ton').prop('checked')){
		$('#inpSin_ton').prop('disabled',false);
	}else {
		$('#inpSin_ton').val('');
		$('#inpSin_ton').prop('disabled',true);
	}
	//重量減トン船
	if($('#chbJuryo_genton').prop('checked')){
		$('#inpJuryo_genton').prop('disabled',false);
	}else {
		$('#inpJuryo_genton').val('');
		$('#inpJuryo_genton').prop('disabled',true);
	}
	//スラスター
	if($('#chbThr').prop('checked')){
		$('#inpBow').prop('disabled',false);
		$('#inpStern').prop('disabled',false);
	}else {
		$('#inpBow').val('');
		$('#inpStern').val('');
		$('#inpBow').prop('disabled',true);
		$('#inpStern').prop('disabled',true);
	}
	//PI保険
	if($('#slctPi_hoken').val() == '999'){
		$('#inpO_pi_hoken').prop('disabled',false);
	}else{
		$('#inpO_pi_hoken').val('');
		$('#inpO_pi_hoken').prop('disabled',true);
	}
	//船長
	if($('#slctNation_cap').val() == '***'){
		$('#inpO_nation_cap').prop('disabled',false);
	}else{
		$('#inpO_nation_cap').val('');
		$('#inpO_nation_cap').prop('disabled',true);
	}
}

//▼文字バイト数計算  ※文字数チェックから呼び出し
function textbyte(str) {
        count=0;
        for(i=0;i<str.length;i++)
        (str.charAt(i).match(/[ｱ-ﾝ]/) || encodeURI(str.charAt(i)).length< 4)?count++:count+=2;
        return count;
}

//更新処理
function updateMizusakiIrai(syoriKbn){
	if($('#chbSin_ton').prop('checked')){
		$('#hdnSin_ton_check').val('1');
	}else {
		$('#hdnSin_ton_check').val('0'); 
	}
	if($('#chbJuryo_genton').prop('checked')){
		$('#hdnJuryo_genton_check').val('1');
	}else {
		$('#hdnJuryo_genton_check').val('0');
	}
	if($('#chbThr').prop('checked')){
		$('#hdnThr_check').val('1');
	}else {
		$('#hdnThr_check').val('0');
	}
	if($('#chbRadar').prop('checked')){
		$('#hdnRadar_check').val('0');
	}else {
		$('#hdnRadar_check').val('1');
	}
	if($('#chbArpa').prop('checked')){
		$('#hdnArpa_check').val('0');
	}else {
		$('#hdnArpa_check').val('1'); 
	}
	if($('#chbGyro').prop('checked')){
		$('#hdnGyro_check').val('0');
	}else {
		$('#hdnGyro_check').val('1');
	}
	if($('#chbAis').prop('checked')){
		$('#hdnAis_check').val('0');
	}else {
		$('#hdnAis_check').val('1'); 
	}
	if($('#chbSyuki').prop('checked')){
		$('#hdnSyuki_check').val('0');
	}else {
		$('#hdnSyuki_check').val('1'); 
	}
	if($('#chbHatsuden').prop('checked')){
		$('#hdnHatsuden_check').val('0');
	}else {
		$('#hdnHatsuden_check').val('1'); 
	}
	if($('#chbKajitori').prop('checked')){
		$('#hdnKajitori_check').val('0');
	}else {
		$('#hdnKajitori_check').val('1'); 
	}
	if($('#chbKiteki').prop('checked')){
		$('#hdnKiteki_check').val('0');
	}else {
		$('#hdnKiteki_check').val('1'); 
	}
	if($('#chbBlackcyl').prop('checked')){
		$('#hdnBlackcyl_check').val('0');
	}else {
		$('#hdnBlackcyl_check').val('1'); 
	}
	if($('#chbGreenlight').prop('checked')){
		$('#hdnGreenlight_check').val('0');
	}else {
		$('#hdnGreenlight_check').val('1'); 
	}
	if($('#chbRedlight').prop('checked')){
		$('#hdnRedlight_check').val('0');
	}else {
		$('#hdnRedlight_check').val('1'); 
	}
	if($('#chbBlackout').prop('checked')){
		$('#hdnBlackout_check').val('0');
	}else {
		$('#hdnBlackout_check').val('1'); 
	}
	if($('#chbHijyosoda').prop('checked')){
		$('#hdnHijyosoda_check').val('0');
	}else {
		$('#hdnHijyosoda_check').val('1'); 
	}

	var param = {
		'appname': nasiappname,
		'prgname':'A113',
		'param1': nasiappname,
		'param2': $('#ssid').val(),
		'param3': $('#kubun').val(),
		'param4': syoriKbn,
		'param5': $('#k_order_no').val(),
		'param6': $('#inpShipName').val(),
		'param7': $('#inpImoNo').val(),
		'param8': $('#inpCallSigne').val(),
		'param9': $('#slctSensyu').val(),
		'param10': $('#inpO_sensyu').val(),
		'param11': $('#slctSenseki').val(),
		'param12': $('#inpO_senseki').val(),
		'param13': $('#inpSenpaku_tel').val(),
		'param14': $('#inpInmaru_tel').val(),
		'param15': $('#inpInmaru_fax').val(),
		'param16': $('#inpSo_ton').val(),
		'param17': $('#hdnSin_ton_check').val(),
		'param18': $('#inpSin_ton').val(),
		'param19': $('#inpJuryo_ton').val(),
		'param20': $('#hdnJuryo_genton_check').val(),
		'param21': $('#inpJuryo_genton').val(),
		'param22': $('#inpZencho').val(),
		'param23': $('#inpSensyu_senkyo').val(),
		'param24': $('#inpSentei').val(),
		'param25': $('#inpKeifuku').val(),
		'param26': $('#inpKeisin').val(),
		'param27': $('#inpKissui').val(),
		'param28': $('#inpKanpan').val(),
		'param29': $('#hdnThr_check').val(),
		'param30': $('#inpBow').val(),
		'param31': $('#inpStern').val(),
		'param32': $('#slctPi_hoken').val(),
		'param33': $('#inpO_pi_hoken').val(),
		'param34': $('#slctNation_cap').val(),
		'param35': $('#inpO_nation_cap').val(),
		'param36': $('#inpNation_crew').val(),
		'param37': $('#hdnRadar_check').val(),
		'param38': $('#hdnArpa_check').val(),
		'param39': $('#hdnGyro_check').val(),
		'param40': $('#hdnAis_check').val(),
		'param41': $('#hdnSyuki_check').val(),
		'param42': $('#hdnHatsuden_check').val(),
		'param43': $('#hdnKajitori_check').val(),
		'param44': $('#hdnBlackout_check').val(),
		'param45': $('#hdnHijyosoda_check').val(),
		'param46': $('#hdnBlackcyl_check').val(),
		'param47': $('#hdnGreenlight_check').val(),
		'param48': $('#hdnRedlight_check').val(),
		'param49': $('#hdnKiteki_check').val(),
		'param50': $('#inpSonota_k').val(),
		'param51': '',
		'param52': $('#inpHonsen_mail').val(),
		'param53': $('#txtTokki').val(),
		'param54': $('#inpMan_soku').val(),
		'param55': $('#inpKou_soku_f').val(),
		'param56': $('#inpKou_soku_h').val(),
		'param57': $('#inpKou_soku_s').val(),
		'param58': $('#inpKou_soku_ds').val(),
		'param59': $('#shimei').val(),
		'param60': $('#kyakkaRiyu').val(),
		'arguments':'param1,param2,param3,param4,param5,param6,param7,param8,param9,param10,param11,param12,param13,param14,param15,param16,param17,param18,param19,param20,param21,param22,param23,param24,param25,param26,param27,param28,param29,param30,param31,param32,param33,param34,param35,param36,param37,param38,param39,param40,param41,param42,param43,param44,param45,param46,param47,param48,param49,param50,param51,param52,param53,param54,param55,param56,param57,param58,param59,param60'
	};
	var retXml = ajaxFunction(param);
	var kekka = $(retXml).find('ret').text();
	var imoKekka = $(retXml).find('imoKekka').text();
	var shipUpdate = $(retXml).find('shipUpdate').text();
	if(kekka === 'I001'){
		if(syoriKbn === '1'){
			$('#prgname').val('A130');
			$('#menuForm').submit();
		}else if(syoriKbn === '2'){
			$('#arguments').val('paramAppName,ssid,parentPG,param1,param2,param3,param4,param5,param6,param7,param8,param9,param10');
			$('#prgname').val('A114');
			$('#param1').val($('#kubun').val());
			$('#param2').val($('#k_order_no').val());
			$('#menuForm').submit();
		}else if(syoriKbn === '3'){
			$('#arguments').val('paramAppName,ssid,parentPG,param1,param2,param3,param4,param5,param6,param7,param8,param9,param10');
			$('#prgname').val('A110');
			$('#param1').val($('#kubun').val());
			$('#param2').val($('#k_order_no').val());
			$('#param3').val('1');
			$('#menuForm').submit();
		}else if(syoriKbn === '4'){
			$('#arguments').val('paramAppName,ssid,parentPG,param1,param2,param3,param4,param5,param6,param7,param8,param9,param10');
			$('#prgname').val('A112');
			$('#param1').val($('#kubun').val());
			$('#param2').val($('#k_order_no').val());
			$('#param3').val(imoKekka);
			$('#param4').val(shipUpdate);
			$('#menuForm').submit();
		}
	}
}

function shimeiApply(){
	$('#prgname').val('A600');
	$('#param1').val($('#k_order_no').val());

	window.open('about:blank','shimeiChk','toolbar=0,directories=0,status=1,resizable=1,scrollbars=1,menubar=0,left=190,top=160,width=650,height=450,');
	$('#menuForm').attr('target','shimeiChk')
	$('#menuForm').submit();

	$('#menuForm').attr('target','_self')
}

function callbackCancel(){
	/* 2022/03/18 戻るボタンで遷移する先をトップページに変更
	$('#prgname').val('A130');
	$('#menuForm').submit();
	*/
	$('#prgname').val($('#parentPG').val());
	$('#param1').val('0');
	$('#menuForm').submit();
}

function changeSlctSensyu(){
	if($('#slctSensyu').val() =='00'){
		$('#lblErrSensyu').text('船種を選択して下さい。');
		return 1;
	}else if($('#slctSensyu').val() =='98' && $('#inpO_sensyu').val() == ''){
		$('#lblErrSensyu').text('船種を入力して下さい。');
		return 1;
	}else {
		$('#lblErrSensyu').text('');
		return 0;
	}
}

function changeSlctSenseki(){
	if($('#slctSenseki').val() =='000'){
		$('#lblErrSenseki').text('船籍を選択して下さい。');
		return 1;
	}else if($('#slctSenseki').val() == '***' && $('#inpO_senseki').val() ==''){
		$('#lblErrSenseki').text('船籍を入力して下さい。');
		return 1;
	}else {
		$('#lblErrSenseki').text('');
		return 0;
	}
}

function changeInpSin_ton(){
	if($('#chbSin_ton').prop('checked') && $('#inpSin_ton').val() ==''){
		$('#lblErrSinton').text('新トン数を入力して下さい。');
		return 1;
	}else {
		$('#lblErrSinton').text('');
		return 0;
	}
}

function changeInpJuryo_genton(){
	if($('#chbJuryo_genton').prop('checked') && $('#inpJuryo_genton').val() ==''){
		$('#lblErrJuryogenton').text('重量減トン船を入力して下さい。');
		return 1;
	}else {
		$('#lblErrJuryogenton').text('');
		return 0;
	}
}

function changeChbThr(){
	if($('#chbThr').prop('checked') && ($('#inpBow').val() =='' || $('#inpBow').val() =='0') && ($('#inpStern').val() =='' || $('#inpStern').val() =='0')){
		$('#lblErrThr').text('バウまたはスターンを入力して下さい。');
		return 1;
	}else {
		$('#lblErrThr').text('');
		return 0;
	}
}

function changeSlctPi_hoken(){
	if($('#slctPi_hoken').val() =='000'){
		$('#lblErrPihoken').text('PI保険会社を選択して下さい。');
		return 1;
	}else if($('#slctPi_hoken').val() =='999' &&  $('#inpO_pi_hoken').val() ==''){
		$('#lblErrPihoken').text('PI保険を入力して下さい。');
		return 1;
	}else {
		$('#lblErrPihoken').text('');
		return 0;
	}
}

function changeSlctNation_cap(){
	if($('#slctNation_cap').val() =='000'){
		$('#lblErrNationcap').text('船長の国籍を選択して下さい。');
		return 1;
	}else if($('#slctNation_cap').val() =='***' &&  $('#inpO_nation_cap').val() ==''){
		$('#lblErrNationcap').text('船長の国籍を入力して下さい。');
		return 1;
	}else {
		$('#lblErrNationcap').text('');
		return 0;
	}
}