// JavaScript Document
var docData = [];
var docPastData = [];
var docFavoriteData = [];
var largeSummary = false;
var largeFavorite = false;
var largeContact = false;
var voteArr = {};
var retCheck = true;
var retVote = true;

var listData = [];
$(document).ready(function(){
	window.name = "W910";
	
	$('#btnGotoHolidayInput').click(function(){
		HolidayInput();
	});
	
	createCalender();
});


function createCalender(){
	var weeks = ['日', '月', '火', '水', '木', '金', '土'];
	//var date = new Date();
	//var year = date.getFullYear();
	var year = $('#hdnNendo').val();
	
	for(var cnt=0; cnt < 12; cnt++){
		var month = cnt + 1;
		var startDate = new Date(year, month - 1, 1); // 月の最初の日を取得
		var endDate = new Date(year, month,  0); // 月の最後の日を取得
		var endDayCount = endDate.getDate(); // 月の末日
		var startDay = startDate.getDay(); // 月の最初の日の曜日を取得
		var dayCount = 1; // 日にちのカウント
		var calendarHtml = ''; // HTMLを組み立てる変数

		calendarHtml += '<table class="tblCalender" cellpadding="0" cellspacing="0"><thead>';
		calendarHtml += '<tr><th colspan="7" class="monthTitle">' + month + '</th></tr>';
		calendarHtml += '<tr>';
		// 曜日の行を作成
		for (var i = 0; i < weeks.length; i++) {
			if(i === 0 ){
				calendarHtml += '<th class="Sunday">' + weeks[i] + '</th>';
			}else if(i===6){
				calendarHtml += '<th class="Saturday">' + weeks[i] + '</th>';
			}else {
				calendarHtml += '<th>' + weeks[i] + '</th>';
			}
			
		}
		calendarHtml += '</thead></tr>';
		calendarHtml += '<tbody>';

		for (var w = 0; w < 6; w++) {
			if(dayCount <= endDayCount){
				calendarHtml += '<tr>';
				for (var d = 0; d < 7; d++) {
					var tdClass = '';
					if(d === 6){
						tdClass = 'Saturday';
					}else if(d === 0){
						tdClass = 'Sunday';
					}
					if (w === 0 && d < startDay) {
						// 1行目で1日の曜日の前
						calendarHtml += '<td class="'+tdClass+'">&nbsp;</td>';
					} else if (dayCount > endDayCount) {
						// 末尾の日数を超えた
						calendarHtml += '<td class="'+tdClass+'">&nbsp;</td>';
					} else {
						calendarHtml += '<td class="tdDay '+tdClass+'" data-month="'+month+'" data-day="'+dayCount+'">' + dayCount + '</td>';
						dayCount++;
					}
				}
				calendarHtml += '</tr>';
			}
		}
		calendarHtml += '</tbody></table>';
		calendarHtml = '<div class="divMonthBlock">' + calendarHtml + '</div>';
		if(month % 6 === 0){ calendarHtml = calendarHtml + '<div class="clear"></div>'; }
		$('#divCalender').append(calendarHtml);
	}
	$('.tdDay').on('click',function(){
		$('*').removeClass('clickDay');
		$('*').removeClass('clickDayRow');
		$(this).addClass('clickDay');
		
		var scrollGoto = 0;
		var getDay = ('00' + $(this).attr('data-day')).slice(-2);
		var clickNum = Number($(this).attr('data-month') + getDay);
		for(var i=0; i<listData.length; i++){
			var retCheck = listData[i].filter(function(elm,idx){
				return elm.fromData <= clickNum && clickNum <=  elm.toData;
			});
			if(retCheck.length > 0){
				$('.tblHoliday tbody tr:eq('+i+')').addClass('clickDayRow');
				if(scrollGoto === 0){
					scrollGoto = $('.tblHoliday tbody tr:eq('+i+')').offset().top;
				}
			}
		}
		//$(window).scrollTop(scrollGoto);
		$("html,body").animate({
			scrollTop:scrollGoto
		});
	});

	createListData();
	
}

function createListData(){
	$('.tblHoliday tbody tr').each(function(idx){
		var listKey = idx;
		var setList = [];
		$(this).children().each(function(){
			if($(this).hasClass('tdBlockNo')){
				listData[listKey] = {};
			}else if($(this).hasClass('tdSpanFromTo')){
				var ftStrArr = $(this).text().split(' ');
				var setData = {
					'fromData': Number(ftStrArr[0].split('/').join('')),
					'toData': Number(ftStrArr[2].split('/').join(''))
				};
				setList.push(setData);
			}
		});
		listData[listKey] = setList;
	});
}

function NPHelp(){
	var hdnWebDocAlias = $('#hdnWebDocAlias').val();
	window.open(hdnWebDocAlias+"help/nphelp_search001.htm");
}

//休暇枠抽選に移る
function HolidayInput(){
	var nendo = $('#hdnNendo').val();
	var chusenCnt = $('#hdnChusenCnt').val();
	$('#prgname').val('W900');
	$('#param1').val(nendo);
	$('#param2').val(chusenCnt);
	$('#param3').val('');
	$('#param4').val('');
	$('#param5').val('');
	$('#param6').val('');
	$('#param7').val('');
	$('#param8').val('');
	$('#param9').val('');
	$('#param10').val('');
	$('#param11').val('');
	$('#param12').val('');
	$('#menuForm').submit();
}