// JavaScript Document

$(document).ready(function(){
	addSpinnerHTML();
	addErrorModalHTML();
});

function addSpinnerHTML(){
	addHTML = '<div id="ajaxSpinner" class="d-flex justify-content-center">' +
					'<div class="spinner-border" role="status" id="spinLoading" style="display:none;">'+
						'<span class="sr-only">Loading...</span>'+
					'</div>'+
				'</div>';
	$('body').append(addHTML);
}

function addErrorModalHTML(){
	var addHTML = '<div class="modal fade" id="modalError" tabindex="-1" role="dialog" aria-labelledby="modalErrorTitle" aria-hidden="true">'+
						'<div class="modal-dialog modal-xl" role="document">'+
							'<div class="modal-content">'+
								'<div class="modal-header">'+
									'<h5 class="modal-title" id="modalErrorTitle"></h5>'+
									'<button type="button" class="close" data-dismiss="modal" aria-label="Close">'+
										'<span aria-hidden="true">&times;</span>'+
									'</button>'+
								'</div>'+
								'<div class="modal-body" id="modalErrorMessage">'+
								'</div>'+
								'<div class="modal-footer">'+
									'<button type="button" class="btn btn-primary" data-dismiss="modal">OK</button>'+
								'</div>'+
							'</div>'+
						'</div>'+
					'</div>';
	
	$('body').append(addHTML);
	
}

function cmAjaxError(XMLHttpRequest, textStatus, errorThrown){
	
	$('#modalErrorTitle').empty();
	$('#modalErrorTitle').text('エラー！');
	
	$('#modalErrorMessage').empty();
	$('#modalErrorMessage').html(errorThrown);
	
	$('#modalError').modal('show');
}


var retXML;
function cmGetXMLbyAjax(param,dispErr,callbackSuccess){
	retXML = '';
	$.ajax({
		async : true,
		url: ajaxURL,
		data : param,
		dataType:'xml',
		scriptCharset: 'utf-8',
		success : function(xml){
			$('.iconSlashwifi').hide();
			var kbn = $(xml).find('kbn').text();
			var msg = $(xml).find('message').text();
			if(dispErr && kbn !== 'I001'){
				$('#modalErrorTitle').text('エラー！');
				$('#modalErrorMessage').html(msg);
				$('#modalError').modal('show');
				$('#spinLoading').hide();
			}
			retXML = xml;
			callbackSuccess();
		},
		error : function(XMLHttpRequest, textStatus, errorThrown){
			$('#spinLoading').hide();
			$('.iconSlashwifi').show();
		},
		timeout : checkTimeout
	});
	
	return retXML;
}

function checkDateFormat(value){
	var check = false;
	var validDate = value;
	validDate = validDate.replace(/-/g, '/')
	if(!validDate.match(/^\d{4}\/\d{2}\/\d{2}$/)){
	}else {
		var validY = validDate.substr(0,4) -0;
		var validM = validDate.substr(5,2) -1;
		var validD = validDate.substr(8,2) -0;
		
		if(validY >= 0 && validM >= 0 && validM <= 11 && validD >= 1 && validD <= 31){
			var validDt = new Date(validY,validM,validD);
			if(isNaN(validDt)){
				check = false;
			}else if(validDt.getFullYear() == validY && validDt.getMonth() == validM && validDt.getDate() == validD){
				check = true;
			}else {
				check = false;
			}
		}else {
			check = false;
		}
	}
	
	return check;
}
function checkTimeFormat(value){
	var check = false;
	var validTime = value;
	if(!validTime.match(/^\d{2}\:\d{2}$/)){
	}else {
		var validH = parseInt(validTime.substr(0,2));
		var validM = parseInt(validTime.substr(3,2));
		
		if(validH >= 0 && validH <= 23 && validM >= 0 && validM <= 59){
			check = true;
		}else {
			check = false;
		}
	}
	
	return check;
}

function checkStrLength(checkStr,checkLen){
	var retCheck = true;
	var length = 0;
	for (var i = 0; i < checkStr.length; i++) {
		var c = checkStr.charCodeAt(i);
		if ((c >= 0x0 && c < 0x81) || (c === 0xf8f0) || (c >= 0xff61 && c < 0xffa0) || (c >= 0xf8f1 && c < 0xf8f4)) {
			length += 1;
		} else {
			length += 2;
		}
	}
	
	if(length > checkLen){
		retCheck = false;
	}
	
	return retCheck;
}